// file: $PDSP/class/fourier_transform/v3.0/fourier_transform_constants.h
//

// make sure definitions are only made once
//
#ifndef __FOURIER_TRANSFORM_CONSTANTS
#define __FOURIER_TRANSFORM_CONSTANTS

// isip include files
//
#ifndef __INTEGRAL_CONSTANTS
#include <integral_constants.h>
#endif

// define the class name
//
#define FT_CLASS_NAME (unichar*)"Fourier_transform"

// direction flags
//
#define FT_FORWARD (long)0
#define FT_REVERSE (long)1
 
// type of data flags
//
#define FT_REAL (long)0
#define FT_COMPLEX (long)1
 
// define the values corresponding to each algorithm
//
#define FT_DF (long)0
#define FT_RAD2 (long)1
#define FT_RAD4 (long)2
#define FT_SR (long)3
#define FT_FH (long)4
#define FT_QF (long)5
#define FT_DITF (long)6
#define FT_PFA (long)7
 
// define the strings corresponding to each algorithm
//
#define FT_DF_NAME (unichar*)"df"
#define FT_RAD2_NAME (unichar*)"radix_2"
#define FT_RAD4_NAME (unichar*)"radix_4"
#define FT_SR_NAME (unichar*)"split_radix"
#define FT_FH_NAME (unichar*)"fh"
#define FT_QF_NAME (unichar*)"qf"
#define FT_DITF_NAME (unichar*)"ditf"
#define FT_PFA_NAME (unichar*)"pfa"
 
// define default algorithm names for real and complex input
//
#define FT_DEFAULT_ALGO FT_RAD2
 
// define default values for the parameters
//
#define FT_DEFAULT_ORDER (long)1024
#define FT_DEFAULT_DATA_TYPE (long)FT_COMPLEX
#define FT_DEFAULT_DBG_LEVEL (long)0
#define FT_DEFAULT_ALGO_NAME (long)FT_SR
#define FT_DEFAULT_INPUT_SIZE (long)8192
 
// define some parameters related to choosing an algorithm automatically
//
#define FT_THRESH_SIZE (long)16

// define format string constants
//
#define FT_OPER_FORMAT (unichar*)"the number of %s:\t%ld\n"
#define FT_MEM_FORMAT (unichar*)"the amount of memory (bytes):\t%ld\n"

// this should be in integral_constants.h
//
#define ISIP_INV_SQRT2 (double)0.707106781188

// end of file
// 
#endif

