// file: /u1/picone/jeida/excise_signal/excise_signal.h
//
// this file defines constants used in excise_signal.cc
//

// Make sure this file is only included once
//
#ifndef __ISIP_EXCISE_SIGNAL
#define __ISIP_EXCISE_SIGNAL

// important constants
//
#define ISIP_PROGRAM_NAME "excise_signal"

// define default values
//
#define DEFAULT_SAMPLE_FREQ 8000.0
#define DEFAULT_INPUT_FILE (char_1*)""
#define DEFAULT_OUTPUT_FILE (char_1*)""
#define DEFAULT_START_TIME 0.0
#define DEFAULT_END_TIME -1.0
#define DEFAULT_NUMBER_BYTES_PER_SAMPLE 2
#define DEFAULT_NUMBER_OF_CHANNELS 2
#define DEFAULT_BUFFER_SIZE 16000
#define DEFAULT_SCALE 1
#define DEFAULT_OUTPUT_MODE 2
#define DEFAULT_PAD_TIME (float_4)0.0
#define DEFAULT_FEATHER_FLAG ISIP_FALSE
#define DEFAULT_SWAP_BYTES ISIP_FALSE
#define STOP_FLAG -1
#define FEATHER_BEGINNING (int_4)1
#define FEATHER_ENDING (int_4)-1

// define some useful math constants
//
#define DEFAULT_LARGE_NUMBER (int_4)(ISIP_2EXP31 - 1)

// define command line identifiers
//
#define ISIP_OPT_INFILE "-infile"
#define ISIP_OPT_OUTFILE "-outfile"
#define ISIP_OPT_SF "-sf"
#define ISIP_OPT_START "-start"
#define ISIP_OPT_END "-end"
#define ISIP_OPT_NBYTES "-num_bytes"
#define ISIP_OPT_NCHAN "-num_chan"
#define ISIP_OPT_OMODE "-out_mode"
#define ISIP_OPT_PAD "-pad_time"
#define ISIP_OPT_FEATHER "-feather"
#define ISIP_OPT_SWAP "-swap_bytes"
#define ISIP_OPT_SCALE "-scale"

// function definitions
//
logical_1 get_parameters_C(int argc, char** argv, float_4& sf,
			   float_4& start_time, float_4& end_time,
			   int_4& num_bytes, int_4& num_chan,
			   int_4& out_mode, float_4& pad_time,
			   logical_1& feather, logical_1& swap_bytes,
			   float_4& scale,  char_1* file_in, char_1* file_out);

logical_1 buffer_swap_bytes_cc(char_1* buffer, int_4 num_samples);

logical_1 buffer_feather_cc(char_1* buffer, int_4 num_samples,
			    int_4 num_chan, int_4 direction);
logical_1 buffer_scale_cc(char_1* buffer, int_4 num_samples,
			  int_4 num_chan, float_4 scale_value);

// end of file
//
#endif
