// file: energy_plot.h
//

// make sure definitions are made only once
//
#ifndef __ISIP_ENERGY_PLOT
#define __ISIP_ENERGY_PLOT

// isip include files
//
#ifndef __ISIP_INTEGRAL
#include <integral.h>
#endif

#ifndef __ISIP_ENERGY_PLOT_CONSTANTS
#include "energy_plot_constants.h"
#endif

// system include files
//
#include <tk.h>
//#include <tkInt.h>
//#include <tkPort.h>

// item: Energy_plot_item
//
// this file defines a structure for the Tk widget Energy_plot. this widget
// will show the energy distribution plot of a audio signal
//
typedef struct Energy_plot_item {

  // required for all canvas sub-items
  //
  Tk_Item header;				// MUST BE FIRST THING IN
						// STRUCTURE
  // interpreter for this widget
  //
  Tcl_Interp* interpreter;
  
  // required data
  //
  Tk_Canvas canvas;				// canvas containing item
  
  // geometry data
  //
  double x;					// defines the x and y coords
  double y;					//    of the insertion point
						//    in canvas units
  int x_loc;					// defines the x and y coords
  int y_loc;					//    of the insertion points
						//    in pixels
  int width;					// desired width of window
  int height;					// desired height of window
						//    don't count on these to
						//    be true
  double* coord_ptr;				// coordinates of widget bounds
  XPoint* plotted_points;			// line endpoints plotted to
						//    the canvas
  int_4 num_points;				// number of points plotted
  Pixmap pixmap;				// pixel map
  
  // graphics settings
  //
  int border_width;				// size of 3-D border
  int relief;					// style of 3-D border
  Tk_3DBorder background;			// color for border, background
  XColor* foreground;				// color for the text
  XColor* highlight;				// color for the highlight
  XColor* highlight_bg;				// color for the highlight bg
  GC highlight_gc;				// window graphics contexts
  GC text_gc;					// text graphics contexts
  int highlight_width;				// thickness of the highlight
  int padX;					// horizontal padding
  int padY;					// vertical padding
  int flags;					// status flags
  char* font;					// font string

  // widget specific data
  //
  char* file_name_d;				// name of file to read from
  int_4 num_chans_d;				// number of channels in file
  int_4 num_bytes_d;				// number of bytes per sample
  int_4 display_channel_d;			// channel to display
  double sf_d;					// sample rate
  int swap_byte_flag_d;				// type of byte swapping
  double start_time_d;				// start time of data
  double end_time_d;				// end time of data
  double win_length_d;                          // window length
  double frame_length_d;                        // frame length
  double pre_emph_coeff_d;                      // preemph coefficient
  int pre_emph_flag_d;                          // preemph flag
  char* window_option_d;                        // window option
  int_4 debug_level_d;				// debug level
  double rms_scale_d;                           // rms scale factor
  double amp_scale_d;                           // amplitude scale factor
  
} Energy_plot_item;

// declare function prototypes which operate on this widget
//
int energy_plot_bbox_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			Energy_plot_item* egy_plot);
int energy_plot_config_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			  Tk_Item* item_ptr, int argc,
			  Tcl_Obj* const* argv, int flags);
int energy_plot_cmd_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
		       Tk_Item* item_ptr, int argc, Tcl_Obj* const* argv);
int energy_plot_coords_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			  Tk_Item* item_ptr, int argc, Tcl_Obj* const* argv);
void energy_plot_destroy_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			    Display* display);
void energy_plot_display_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			    Display* display, Drawable drawable,
			    int x, int y, int width, int height);
void energy_plot_event_cc(ClientData client_data, XEvent* event_ptr);
int energy_plot_instance_cc(ClientData client_data, Tcl_Interp* interpreter,
			    int argc, Tcl_Obj* const* argv);
logical_1 energy_plot_redraw_cc(Energy_plot_item* egy_plot);
void energy_plot_scale_cc(Tk_Canvas canvas, Tk_Item* item_ptr, double origin_x,
			  double origin_y, double scale_x, double scale_y);
double energy_plot_to_point_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			       double* point_ptr);
int energy_plot_plot_points_cc(Energy_plot_item* egy_plot, int_4& num_pts,
                               XPoint** points, int width, int height,
			       int x_offset, int y_offset, Display* display,
			       Drawable drawable);

// declare prototypes for auxiliary functions
//
logical_1 energy_pre_emphasize_data_cc(double* data, double coeff,
				       long num_samples);
logical_1 energy_window_function_cc(double* data, int_4 num_samples,
				    Energy_plot_item* energy_plot);
logical_1 compute_energy_cc(double* data, int_4 num_samples, double& energy,
			    double rms_scale_factor,
			    double amplitude_scale_factor);

// declare a static array to hold the configuration specifications used
// to automatically process arguments to the command that creates a
// Energy_plot and to the configure operation that changes a widget.
// they define the command line flag, its type, its resource name, its
// class name, and its default value. Tk_Offset is a macro that gets the
// address of the structure member so the Energy_plot struct can be
// modified directly
//
static Tk_ConfigSpec energy_plot_config_specs[] = {

  // widget parameter configurations
  //
  {TK_CONFIG_INT, (char*)ENERGY_X_LOC_PARAM, "x_loc", "X_loc",
   (char*)"0", Tk_Offset(Energy_plot_item, x_loc), 0},
  {TK_CONFIG_INT, (char*)ENERGY_Y_LOC_PARAM, "y_loc", "Y_loc",
   (char*)"0", Tk_Offset(Energy_plot_item, y_loc), 0},  
  {TK_CONFIG_INT, (char*)ENERGY_HEIGHT_PARAM, "height", "Height",
   (char*)ENERGY_DEFAULT_HEIGHT_STR, Tk_Offset(Energy_plot_item, height), 0},
  {TK_CONFIG_INT, (char*)ENERGY_WIDTH_PARAM, "width", "width",
   (char*)ENERGY_DEFAULT_WIDTH_STR, Tk_Offset(Energy_plot_item, width), 0},  

  // foreground color configuration
  //
  {TK_CONFIG_COLOR, (char*)ENERGY_FOREGROUND, "foreground", "Foreground",
   (char*)ENERGY_DEFAULT_FOREGROUND_COLOR,
   Tk_Offset(Energy_plot_item, foreground), 0},
  {TK_CONFIG_SYNONYM, (char*)ENERGY_FG, "foreground", (char *) NULL,
   (char *) NULL, 0, 0},
  
  // background color configuration
  //
  {TK_CONFIG_BORDER, (char*)ENERGY_BACKGROUND, "background", "Background",
   (char*)ENERGY_DEFAULT_BACKGROUND_COLOR,
   Tk_Offset(Energy_plot_item, background), TK_CONFIG_COLOR_ONLY},
  {TK_CONFIG_BORDER, (char*)ENERGY_BACKGROUND, "background", "Background",
   (char*)ENERGY_DEFAULT_BACKGROUND_COLOR,
   Tk_Offset(Energy_plot_item, background), TK_CONFIG_MONO_ONLY},
  {TK_CONFIG_SYNONYM, (char*)ENERGY_BG, "background", (char *) NULL,
   (char *) NULL, 0, 0},

  // highlight color configuration
  //
  {TK_CONFIG_COLOR, (char*)ENERGY_HGLTCOLOR, "highlightColor",
   "HighlightColor", (char*)ENERGY_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Energy_plot_item, highlight), TK_CONFIG_COLOR_ONLY},
  {TK_CONFIG_COLOR, (char*)ENERGY_HGLTCOLOR, "highlightColor",
   "HighlightColor", (char*)ENERGY_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Energy_plot_item, highlight), TK_CONFIG_MONO_ONLY},
  {TK_CONFIG_COLOR, (char*)ENERGY_HGLTBACKGROUND, "highlightBackground",
   "HighlightBackground", (char*)ENERGY_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Energy_plot_item, highlight_bg), TK_CONFIG_COLOR_ONLY},
  {TK_CONFIG_COLOR, (char*)ENERGY_HGLTBACKGROUND, "highlightBackground",
   "HighlightBackground", (char*)ENERGY_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Energy_plot_item, highlight_bg), TK_CONFIG_MONO_ONLY},

  // border width configuration
  //
  {TK_CONFIG_PIXELS, (char*)ENERGY_BORDERWIDTH, "border_width", "Border_Width",
   (char*)ENERGY_DEFAULT_BORDERWIDTH,
   Tk_Offset(Energy_plot_item, border_width),0},
  {TK_CONFIG_SYNONYM, (char*)ENERGY_BD, "border_width", (char *) NULL,
   (char *) NULL, 0, 0},

  // relief type configuration
  //
  {TK_CONFIG_RELIEF, (char*)ENERGY_RELIEF, "relief", "Relief",
   (char*)ENERGY_DEFAULT_RELIEF_NAME, Tk_Offset(Energy_plot_item, relief), 0},

  // horizontal and vertical padding configuration
  //
  {TK_CONFIG_PIXELS, (char*)ENERGY_PADX, "padX", "Pad",
   (char*)ENERGY_DEFAULT_HORIZONTAL_PADDING,
   Tk_Offset(Energy_plot_item, padX), 0},
  {TK_CONFIG_PIXELS, (char*)ENERGY_PADY, "padY", "Pad",
   (char*)ENERGY_DEFAULT_VERTICAL_PADDING, Tk_Offset(Energy_plot_item, padY),
   0},

  // energy plot specific parameters
  //
  // widget parameter configurations
  //
  {TK_CONFIG_STRING, (char*)ENERGY_AUDIO_FILE_PARAM, "file", "File",
   (char*)NULL, Tk_Offset(Energy_plot_item, file_name_d), 0},  
  {TK_CONFIG_INT, (char*)ENERGY_NUM_CHANS_PARAM, "num_chans", "Num_chans",
   (char*)ENERGY_DEFAULT_NUM_CHANS, Tk_Offset(Energy_plot_item, num_chans_d),
   0},
  {TK_CONFIG_INT, (char*)ENERGY_NUM_BYTES_PARAM, "num_bytes", "Num_bytes",
   (char*)ENERGY_DEFAULT_NUM_BYTES, Tk_Offset(Energy_plot_item, num_bytes_d),
   0},
  {TK_CONFIG_INT, (char*)ENERGY_DISPLAY_CHAN_PARAM, "display_chan",
   "Display_chan", (char*)ENERGY_DEFAULT_DISPLAY_CHAN,
   Tk_Offset(Energy_plot_item, display_channel_d), 0},
  {TK_CONFIG_DOUBLE, (char*)ENERGY_SAMPLE_FREQ_PARAM, "sample_freq",
   "Sample_freq", (char*)ENERGY_DEFAULT_SAMPLE_FREQ,
   Tk_Offset(Energy_plot_item, sf_d), 0},
  {TK_CONFIG_DOUBLE, (char*)ENERGY_START_TIME_PARAM, "start_time",
   "Start_time", (char*)ENERGY_DEFAULT_START_TIME,
   Tk_Offset(Energy_plot_item, start_time_d), 0},
  {TK_CONFIG_DOUBLE, (char*)ENERGY_END_TIME_PARAM, "end_time", "End_time",
   (char*)ENERGY_DEFAULT_END_TIME, Tk_Offset(Energy_plot_item, end_time_d),
   0},
  {TK_CONFIG_INT, (char*)ENERGY_SWAP_BYTES_PARAM, "swap_bytes", "Swap_bytes",
   (char*)ENERGY_DEFAULT_SWAP_BYTES, Tk_Offset(Energy_plot_item,
						swap_byte_flag_d), 0},
  {TK_CONFIG_INT, "-debug", "debug", "Debug",
   (char*)ENERGY_DEFAULT_DEBUG, Tk_Offset(Energy_plot_item, debug_level_d),
   0},
  {TK_CONFIG_DOUBLE, (char*)ENERGY_WINLEN, "winlen", "Winlen",
   (char*)ENERGY_DEFAULT_WIN_LEN,
   Tk_Offset(Energy_plot_item, win_length_d), 0},
  {TK_CONFIG_DOUBLE, (char*)ENERGY_FRAMELEN, "framelen", "Framelen",
   (char*)ENERGY_DEFAULT_FRAME_LEN,
   Tk_Offset(Energy_plot_item, frame_length_d), 0},
  {TK_CONFIG_DOUBLE, (char*)ENERGY_PREEMPH, "preemph_coeff", "Preemph_coeff",
   (char*)ENERGY_DEFAULT_PREEMPH,
   Tk_Offset(Energy_plot_item, pre_emph_coeff_d), 0},
  {TK_CONFIG_INT, (char*)ENERGY_PREFLAG, "use_preemph", "Use_preemph",
   (char*)ENERGY_DEFAULT_PREFLAG,
   Tk_Offset(Energy_plot_item, pre_emph_flag_d), 0},
  {TK_CONFIG_STRING, (char*)ENERGY_WIN_OPTION, "filter", "Filter",
   (char*)ENERGY_DEFAULT_WINDOW,
   Tk_Offset(Energy_plot_item, window_option_d), 0},
  {TK_CONFIG_DOUBLE, (char*)ENERGY_RMS_SCALE_FACTOR, "rms_scale",
   "Rms_scale", (char*)ENERGY_DEFAULT_SCALE_FACTOR,
   Tk_Offset(Energy_plot_item, rms_scale_d), 0},
  {TK_CONFIG_DOUBLE, (char*)ENERGY_AMP_SCALE_FACTOR, "amp_scale",
   "Amp_scale", (char*)ENERGY_DEFAULT_AMP_SCALE,
   Tk_Offset(Energy_plot_item, amp_scale_d), 0},
    
  // marks the end of the table - this must be the last entry in the table
  //
  {TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
   (char *) NULL, 0, 0}
};

// the structure below defines the energy plot item by means of procedures
// that can be invoked by generic item code implemented in tk
//
static Tk_ItemType Energy_plot_type = {

  (char*)ENERGY_WIDGET_NAME, 			// name of widget
  sizeof(Energy_plot_item),			// item size
  energy_plot_cmd_cc,				// creation process
  energy_plot_config_specs,			// configuration specs
  energy_plot_config_cc, 			// configuration process
  energy_plot_coords_cc,			// coords canvas process
  energy_plot_destroy_cc,			// deletion of the widget
  energy_plot_display_cc,			// display process
  TK_CONFIG_OBJS,				// always redraw
  energy_plot_to_point_cc,			// tk point process
  (Tk_ItemAreaProc*) NULL,			// tk area process
  (Tk_ItemPostscriptProc*) NULL,		// tk postscript process
  energy_plot_scale_cc,				// tk scale process
  (Tk_ItemTranslateProc*) NULL,			// tk translate process
  (Tk_ItemIndexProc*) NULL,			// tk index process
  (Tk_ItemCursorProc*) NULL,			// tk cursor process
  (Tk_ItemSelectionProc*) NULL,			// tk selection process
  (Tk_ItemInsertProc*) NULL,			// tk insertion process
  (Tk_ItemDCharsProc*) NULL,			// tk dchars process?
  (Tk_ItemType*) NULL				// next pointer - init by tk
};

// end of include file
//
#endif
