#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/zoom.tcl
#
# methods to zoom in and out of windows
#

# list of procedures:
#
#  zoom_in_proc {}
#  zoom_out_proc {}
#  zoom_full_proc {}
#  zoom_brackets_proc {}
#

# procedure: zoom_in_proc
#
# arguments: none
#
# return: none
#
# process: zoom in
#
proc zoom_in_proc {} {

    # declare global variables
    #
    global bracket_start
    global bracket_end
    global bracket_duration
    global window_start
    global window_end
    global window_duration

    global maximum_time
    global zoom_min
    global plot_width

    # find the midpoint of the window
    #
    set midpoint [eval expr ($window_start + $window_end) / 2]
    
    # make sure not to zoom in too far
    #
    if {$window_duration < $zoom_min} {
	set window_duration $zoom_min
    }

    # set the window start time
    #
    set window_start [eval expr $midpoint - $window_duration / 4]
    if {$window_start < 0.0} {
	set window_start 0.0
    }
    
    # set the window end time
    #
    set window_end [eval expr $midpoint + $window_duration / 4]
    if {$window_end > $maximum_time} {
	set window_end $maximum_time
    }
    
    # set the window duration
    #
    set window_duration [eval expr $window_end - $window_start]
    
    # set the bracket start time and line position
    #
    if {$bracket_start < $window_start} {
	set bracket_start $window_start
    } elseif {$bracket_start > $window_end} {
	set bracket_start $window_start
    }
    
    # set the bracket end time
    #
    if {$bracket_end > $window_end} {
	set bracket_end $window_end
    } elseif {$bracket_end < $window_start} {
	set bracket_end $window_end
    }
    
    # set the bracket duration
    #
    set bracket_duration [eval expr $bracket_end - $bracket_start]
    
    # update the window
    #
    update_window
}

# procedure: zoom_out_proc
#
# arguments: none
#
# return: none
#
# process: zoom out
#
proc zoom_out_proc {} {

    # declare global variables
    #
    global bracket_start
    global bracket_end
    global bracket_duration
    global window_start
    global window_end
    global window_duration

    global maximum_time
    global plot_width
    
    # find the midpoint of the window
    #
    set midpoint [eval expr ($window_start + $window_end) / 2]
    
    # set the window start time
    #
    set window_start [eval expr $midpoint - $window_duration ]
    if {$window_start < 0.0} {
	set window_start 0.0
    }
    
    # set the window end time
    #
    set window_end [eval expr $midpoint + $window_duration ]
    if {$window_end > $maximum_time} {
	set window_end $maximum_time
    }
    
    # set the window duration
    #
    set window_duration [eval expr $window_end - $window_start]
    
    # set the bracket start time and line position
    #
    if {$bracket_start < $window_start} {
	set bracket_start $window_start
    }
    
    # set the bracket end time
    #
    if {$bracket_end > $window_end} {
	set bracket_end $window_end
    }
    
    # set the bracket duration
    #
    set bracket_duration [eval expr $bracket_end - $bracket_start]
    
    # update windows
    #
    update_window
}

# procedure: zoom_full_proc
#
# arguments: none
#
# return: none
#
# process: zoom in full
#
proc zoom_full_proc {} {
    
    # declare global variables
    #
    global bracket_start
    global bracket_end
    global bracket_duration
    global window_start
    global window_end
    global window_duration

    global maximum_time
    global plot_width
    
    # set the window start time
    #
    set window_start 0.0
    
    # set the window end time
    #
    set window_end $maximum_time
    
    # set the window duration
    #
    set window_duration [eval expr $window_end - $window_start]
    
    # set the bracket start time and line position
    #
    if {$bracket_start < $window_start} {
	set bracket_start $window_start
    }
    
    # set the bracket end time
    #
    if {$bracket_end > $window_end} {
	set bracket_end $window_end
    }
    
    # set the bracket duration
    #
    set bracket_duration [eval expr $bracket_end - $bracket_start]
    
    # update windows
    #
    update_window
}

# procedure: zoom_brackets_proc
#
# arguments: none
#
# return: none
#
# process to zoom the bracket marks
#
proc zoom_brackets_proc {} {

    # declare global variables
    #
    global bracket_start
    global bracket_end
    global bracket_duration
    global window_start
    global window_end
    global window_duration

    global maximum_time
    global current_time
    
    # set the window start and end time
    #
    set window_start $bracket_start
    set window_end $bracket_end
    
    # make sure these are valid
    #
    if {$window_end < $window_start} {
	set temp $window_end
	set window_end $window_start
	set window_start $temp
    }
    
    # set the window duration
    #
    set window_duration [eval expr $window_end - $window_start]
    
    # find the midpoint of the window
    #
    set current_time [eval expr ($window_start + $window_end) / 2]
    
    # update windows
    #
    update_window
}

#
# end of file
