#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/window.tcl
#
# procedures to modify the windows on the transcriber
#

# list of procedures:
#
#  window_ahead_proc {}
#  window_back_proc {}
#  curr_window_proc {}
#  update_window {}
#  warning_proc {message}
#

# procedure: window_ahead_proc
#
# arguments: none
#
# return: none
#
# process: window_ahead_proc
#
proc window_ahead_proc {} {

    # declare global variables
    #
    global window_start
    global window_end
    global window_duration

    global current_time
    global maximum_time

    global p

    # set the window end point
    #
    set window_end [eval expr $window_end + $window_duration]
    if {$window_end > $maximum_time} {
	set window_end $maximum_time
    } 
    
    # set the window start point
    #
    set window_start [eval expr $window_end - $window_duration]

    # set the current time
    #
    if {[eval expr $current_time + $window_duration] <= $maximum_time} {
	set current_time [eval expr $current_time + $window_duration]
    }

    # set the bracket lines to boundaries
    #
    bracket_plot_proc $window_start $window_end

    # update windows
    #
    update_window
}

# procedure: window_back_proc
#
# arguments: none
#
# return: none
#
# process: window_back_proc
#
proc window_back_proc {} {

    # declare global variables
    #
    global window_start
    global window_end
    global window_duration

    global current_time
    global maximum_time

    global p

    # set the window start point
    #
    set window_start [eval expr $window_start - $window_duration]

    if {$window_start < 0.0} {
	set window_start 0.0
    }
    
    # set the window end time
    #
    set window_end [eval expr $window_start + $window_duration]
    
    # set the current time
    #
    if {$current_time > $window_duration} {
	set current_time [eval expr $current_time - $window_duration]
    }

    # copy the window coordinates to the bracket coordinates
    #
    bracket_plot_proc $window_start $window_end

    # update windows
    #
    update_window
}

# procedure: curr_window_proc
#
# arguments: none
#
# return: none
#
# procedure to set current window
#
proc curr_window_proc {} {
    
    # declare globals
    #
    global window_start
    global window_end
    global window_duration
    
    global maximum_time
    global current_time
    
    global curr_ind
    global current_channel

    global cutt_start
    global cutt_end
    
    # set window start and end times
    #
    set window_start 0.0
    set window_end $maximum_time
    set window_duration [eval expr $window_end - $window_start]

    # set current time accordingly
    #
    set current_time [eval expr ($window_start + $window_end) / 2]

    # set the bracket marks and draw brackets
    #
    bracket_plot_proc $cutt_start $cutt_end

    # update the display
    #
    update_window
}

# procedure: update_window
#
# arguments: none
#
# return: none
#
# procedure to update window display
#
proc update_window {} {

    # declare globals
    #
    global plot_width

    global word_mode

    global ww
    global p

    # update the width of the plots
    #
    set plot_width [expr [winfo width $p.chan0_plot] - 1]

    # update the channel plots
    #
    plot_channel_proc

    # force an update of the window
    # 
    display_time_proc
}

# procedure: warning_proc
#
# arguments:
#  message: input string
#
# return: none
#
# procedure to pop-up warning window
#
proc warning_proc {message} {

    # declare globals
    #
    global transcriber_title
    global bg_col
    global wrn

    # destroy all previously existing boxes
    #
    if {[winfo exists $wrn] == 1} {
	destroy $wrn
    }

    # create a new warning boxes
    #
    toplevel $wrn
    wm title $wrn "$transcriber_title Warning"
    wm geometry $wrn "+300+250"
    wm focusmodel $wrn active

    # make frames
    #
    frame $wrn.top_f -borderwidth 1 -relief sunken -height 120 \
	    -background $bg_col
    frame $wrn.bot_f -height 40 -background $bg_col
    pack $wrn.top_f $wrn.bot_f -side top -fill both

    # sound a warning bell to get the users attention
    #
    bell

    # show message
    #
    message $wrn.mesg -justify center -width 3i -text $message \
	    -background $bg_col
    pack $wrn.mesg -fill both -expand true -padx 1 -pady 1 -in $wrn.top_f
    
    # add dismiss button
    #
    button $wrn.quit -text Dismiss -width 10 -default active \
	    -background $bg_col -command "destroy $wrn"
    pack $wrn.quit -padx 1 -pady 1m -in $wrn.bot_f

    # key bindings
    #
    bind $wrn <Return> "destroy $wrn"
}

#
# end of file
