#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/verify.tcl
#
# procedures to run the verify mode on the transcriber   
#

# list of procedures:
#
#  verify_proc {}
#

# procedure: verify_proc
#
# arguments: none
#
# return: none
#
# this procedure starts at the current utterance for the selected
# channel and loops through all the remaining utterances
#
proc verify_proc {} {

    # declare globals
    #
    global current_channel
    global curr_ind

    global audiolist
    global arraylist

    global pause_time
    global verify_flag

    global p
    global callflag

    # toggle the verify flag
    #
    if {$verify_flag == 0} {
	set verify_flag 1
	$p.verify configure -state active
    } else {
	set verify_flag 0
	$p.verify configure -state normal
    }

    # set the maximum number of utterances to be played
    #
    set num_utt [llength $audiolist]

    # now loop through the current utterances
    #
    set i $curr_ind
    while {$verify_flag == 1} {

	# update the window
	#
	update

	# account for events being taken care of in the previous update
	#
	if {$verify_flag == 1} {

	    # show the button to be avtive
	    #
	    $p.verify configure -state active
	    
	    # make this current and play it
	    #
	    if {$i >= $num_utt} {
		
		# reset the verify flag
		#
		set verify_flag 0
		$p.verify configure -state normal
		break

	    } else {

		# set the call flag
		#
		set callflag 1
		
		# set the current utterance
		#
		set_current_proc $i

		# update the window as needed
		#
		update idletasks

		# pause for the required time
		#
		set ptime [expr $pause_time * 1000]
		set pt [string first "." $ptime]
		set ptime [string range $ptime 0 [expr $pt - 1]]
		after $ptime

		# play the current utterance
		#
		play_utt_proc 0
	    
		# move to the next utterance
		#
		incr i
	    }
	} else {

	    # reset the verify flag
	    #
	    set verify_flag 0
	    $p.verify configure -state normal
	}
    }
    
    # update the status
    #
    update
}

#
# end of file
