#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/quit.tcl
#
# procedures that shuts down the application and quits
#

# list of procedures:
#
#  quit_proc {}
#  quit_save_proc {}
#  quit_ok_proc {}
#

# procedure: quit_proc
#
# arguments: none
#
# return: none
#
# this procedure prompts the user to either save and quit the application or
# quit the application without saving
#
proc quit_proc {} {

    # create globals
    #
    global w_quit
    set w_quit ".quit"

    global transcriber_title
    global bg_col

    global bookmark_flag

    global lock

    # quit without saving if a lock is set
    #
    if {$lock == 1} {
	quit_ok_proc
    }

    # don't recreate the window, try to reuse existing one
    #
    if { [winfo exists $w_quit] == 1 } {
        wm deiconify $w_quit
        raise $w_quit
	
    } else {
	
        # create a new window
        #
        toplevel $w_quit
        wm title $w_quit "$transcriber_title Exit"
	wm geometry $w_quit "+300+200"
	wm focusmodel $w_quit active	

	# make a bottom frame
	#
	frame $w_quit.foot -background $bg_col
	pack $w_quit.foot -side bottom -fill x -pady 2m

        button $w_quit.save -width 6 -default active -text Save \
		-background $bg_col -command {quit_save_proc}
        button $w_quit.ok -width 6 -text Quit -command {quit_ok_proc} \
		-background $bg_col
	button $w_quit.cancel -width 6 -text Cancel -background $bg_col \
		-command "destroy $w_quit"
        pack $w_quit.save $w_quit.ok $w_quit.cancel -side left  -fill x \
		-padx 1m -pady 1m -expand true -in $w_quit.foot

	# make a message frame
	#
	frame $w_quit.top -background $bg_col
	pack $w_quit.top -side top -fill x -padx 1m -pady 1m

	message $w_quit.msg -justify center -width 2i -background $bg_col \
		-text "Quitting will destroy the autosave files. \
		Do you want to save data before you quit?"
	pack $w_quit.msg -side top -fill both -in $w_quit.top
    }

    bind $w_quit <Return> {quit_ok_proc}
}

# procedure: quit_save_proc
#
# arguments: none
#
# return: none
#
# procedure to save and quit
#
proc quit_save_proc {} {

    # save data
    #
    save_proc

    # exit
    #
    quit_ok_proc
}

# procedure: quit_ok_proc
#
# arguments: none
#
# return: none
#
# procedure to quit the program
#
proc quit_ok_proc {} {

    # globals
    #
    global auto_t0_file
    global auto_w0_file
 
    global bookmark_flag

    # if there is no stop bookmark put one
    #
    if {$bookmark_flag == 1} {
	bookmark_entry_proc
    }
    
    # delete tmp files
    #
    if {[file exists $auto_t0_file]} {
	exec rm -f $auto_t0_file
    }
    if {[file exists $auto_w0_file]} {
	exec rm -f $auto_w0_file
    }

    # exit
    #
    exit
}

#
# end of file
