#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/plot.tcl
#
# procedures for plotting data
#

# list of procedures:
#
#  plot_channel_proc {}
#  plot_turns_proc {uttlist ch y_in}
#  update_turns_proc {}
#  update_gain_proc {gain}
#  update_brightness_proc {gain}
#  update_contrast_proc {gain}
#  tk_popup {menu x y {entry {}}}
#

# procedure: plot_channel_proc
#
# arguments: none
#
# return: none
#
# procedure to plot the signal for the current channel
#
proc plot_channel_proc {} {
    
    # declare globals
    #
    global window_start
    global window_end
    global window_duration
    global maximum_time

    global bracket_start
    global bracket_end
    
    global bracket_signal_start_line
    global bracket_signal_end_line
    global bracket_energy_start_line
    global bracket_energy_end_line
    global bracket_spec_start_line
    global bracket_spec_end_line

    global sig_plot_0
    global energy_plot_0
    global spec_plot_0

    global plot_width
    global energy_ht
    global signal_ht

    global chan0_uttlist

    global tscale_height
    global tscale_sep
    global tscale_frame

    global window_len
    global frame_len
    global preemph_coeff
    global preemph_flag
    global window_option
    global window_size
    global rms_factor
    global amplitude_gain

    global fftlen_d
    global brightness_d
    global contrast_d
    
    global audio_file

    global p

    # make sure this is a valid plot
    #
    if {$window_duration <= 0} {
	warning_proc "Error in plotting --- signal duration is 0 or \
		smaller. \n\nPlease check and adjust time marks \
		appropriately."
	return
    }
 
    # plot the energy of the signal
    #
    $p.energy0_plot itemconfigure $energy_plot_0 -start_time $window_start \
	    -end_time $window_end -height $energy_ht -width $plot_width \
	    -use_preemph $preemph_flag -filter $window_option \
	    -framelen $frame_len -preemph_coeff $preemph_coeff \
	    -rms_scale $rms_factor -amp_scale $amplitude_gain \
	    -file $audio_file -borderwidth 1

    # plot the signal
    #
    $p.chan0_plot itemconfigure $sig_plot_0 -start_time $window_start \
	    -end_time $window_end -height $signal_ht -width $plot_width \
	    -gain_factor $amplitude_gain -file $audio_file -borderwidth 1


    # plot the spectrogram of the signal
    #
    $p.spec0_plot itemconfigure $spec_plot_0 -start_time $window_start \
	    -end_time $window_end -height 130 -width $plot_width \
	    -use_preemph $preemph_flag -filter $window_option \
	    -framelen $frame_len -preemph_coeff $preemph_coeff \
	    -brightness $brightness_d -contrast $contrast_d \
	    -file $audio_file -borderwidth 1

    # compute the location of the bracket start and end lines
    #
    set x_start [eval expr int(($bracket_start-$window_start) * \
            ($plot_width / $window_duration))]
    set x_end [eval expr int(($bracket_end-$window_start) * \
            ($plot_width / $window_duration))]
    
    # draw a line at the start and end time
    #
    $p.chan0_plot coords $bracket_signal_start_line $x_start 0 \
	    $x_start [winfo height $p.chan0_plot]
    $p.chan0_plot coords $bracket_signal_end_line $x_end 0 $x_end \
	    [winfo height $p.chan0_plot]

    $p.energy0_plot coords $bracket_energy_start_line $x_start 0 \
	    $x_start [winfo height $p.energy0_plot]
    $p.energy0_plot coords $bracket_energy_end_line $x_end 0 $x_end \
	    [winfo height $p.energy0_plot]

    $p.spec0_plot coords $bracket_spec_start_line $x_start 0 \
	    $x_start [winfo height $p.spec0_plot]
    $p.spec0_plot coords $bracket_spec_end_line $x_end 0 $x_end \
	    [winfo height $p.spec0_plot]

    # remove all old time lines
    #
    $p.energy0_plot delete t1_line
    $p.chan0_plot delete t2_line
    $p.spec0_plot delete t3_line

    # plot time lines
    #
    set t [expr floor($window_start)]
    set lh [expr 0.5 * $tscale_height]
    if {[expr $t + $tscale_sep] < $window_start} {
	set t [expr $t + 2 * $tscale_sep]
	set lh $tscale_height
    }
    while {$t < $window_end} {
	
	# set the coordinates
	#
	set xx [eval expr int(($t - $window_start) * \
		($plot_width / $window_duration))]
	
	# draw the line
	#
	$p.energy0_plot create line $xx 0 $xx $lh -tag t1_line
	$p.energy0_plot create line $xx [winfo height $p.energy0_plot] \
		$xx [expr [winfo height $p.energy0_plot] - $lh] -tag t1_line

	# draw the line
	#
	$p.chan0_plot create line $xx 0 $xx $lh -tag t2_line
	$p.chan0_plot create line $xx [winfo height $p.chan0_plot] \
		$xx [expr [winfo height $p.chan0_plot] - $lh] -tag t2_line

	# draw the line
	#
	$p.spec0_plot create line $xx 0 $xx $lh -tag t3_line
	$p.spec0_plot create line $xx [winfo height $p.spec0_plot] \
		$xx [expr [winfo height $p.spec0_plot] - $lh] -tag t3_line

	# increment time stamp
	#
	set t [expr $t + $tscale_sep]
	if {[expr floor($t)] == $t} {
	    set lh $tscale_height
	} else {
	    set lh  [expr 0.5 * $tscale_height]
	}
    }
}

# procedure: plot_turns_proc
#
# arguments:
#  uttlist: utterance list
#  ch: input channel
#  y_in: y coordinate
#
# return: none
#
# procedure to plot the turn display
#
proc plot_turns_proc {uttlist ch y_in} {

    # declare globals
    #
    global window_start
    global window_end
    global window_duration

    global plot_width
    global maximum_time

    global font_0

    global p

    # set the coordinates for the text labels
    #
    set y_t [expr $y_in-5]

    # get the start and end time for each utterance
    #
    foreach item $uttlist {
	foreach {cid uid spkr sex age start end trans} $item {
	    
	    # check if this utterance is covered by the window
	    #
	    set tstart $maximum_time
	    set tend 0
	    if {$start < $window_end} {
		if {$start >= $window_start} {
		    set tstart $start
		} else {
		    set tstart $window_start
		}
	    }
	    
	    if {$end >= $window_start} {
		if {$end <= $window_end} {
		    set tend $end
		} else {
		    set tend $window_end
		}
	    }

	    # draw line only if end is after start
	    #
	    if {$tstart < $tend} {
		set x1 [eval expr ($plot_width / $window_duration) \
			* ($tstart - $window_start)]
		set x2 [eval expr ($plot_width / $window_duration) \
			* ($tend - $window_start)]

		# set the id string
		#
		set uttid [format "%s-%.4d" $ch $uid]
		set x_t [expr $x1+20]

		# plot the line
		#
		$p.trn_plot create line $x1 $y_in $x2 $y_in -width 1.0 \
			-arrow both -arrowshape {1 2 4}
		$p.trn_plot create text $x_t $y_t -text $uttid -font $font_0
	    }
	}
    }
}

# procedure: update_turns_proc
#
# arguments: none
#
# return: none
#
# procedure to update the turn display
#
proc update_turns_proc {} {

    # declare globals
    #
    global chan0_uttlist

    global chlabel

    global word_mode

    global p
    
    # plot the turn display if normal operation
    #
    if {$word_mode == 0} {
	$p.trn_plot delete all
	plot_turns_proc $chan0_uttlist $chlabel 15
    }
}

# procedure: update_gain_proc
#
# arguments:
#  gain: amplitude gain
#
# return: none
#
# procedure to update the amplitude gain
#
proc update_gain_proc {gain} {

    # declare globals 
    #
    global amplitude_gain
    global current_amplitude

    # ckeck if the gain has alreay been set to avoid unnecessary updates
    #
    if {$current_amplitude == $amplitude_gain} {
	return
    }

    # set the current value of the amplitude gain
    #
    set current_amplitude $gain

    # update the amplitude gain value and display
    #
    set amplitude_gain $gain

    # update display
    #
    update_window
}

# procedure: update_brightness_proc
#
# arguments:
#  gain: brightness gain
#
# return: none
#
# procedure to update the brightness gain
#
proc update_brightness_proc {gain} {

    # declare globals 
    #
    global brightness_d
    global current_brightness

    # ckeck if the gain has alreay been set to avoid unnecessary updates
    #
    if {$current_brightness == $brightness_d} {
	return
    }

    # set the current value of the brightness
    #
    set current_brightness $gain
    
    # update the brightness value and display
    #
    set brightness_d $gain

    # update display
    #
    update_window
}

# procedure: update_contrast_proc
#
# arguments:
#  gain: contrast gain
#
# return: none
#
# procedure to update the contrast gain
#
proc update_contrast_proc {gain} {

    # declare globals 
    #
    global contrast_d
    global current_contrast

    # ckeck if the gain has alreay been set to avoid unnecessary updates
    #
    if {$current_contrast == $contrast_d} {
	return
    }

    # set the current value of the contrast
    #
    set current_contrast $gain
    
    # update the contrast value and display
    #
    set contrast_d $gain

    # update display
    #
    update_window
}

# procedure: update_gain_proc
#
# arguments:
#  menu: input pop up menue
#  x: x coordinate
#  y: y coordinate
#  entry {}: input list
# 
# return: none
#
# procedure to make sure that the menu focus problem with Tk 8.0 does
# not cause trouble --- this is basically a rewrite of the original
# Tk function
#
proc tk_popup {menu x y {entry {}}} {
    global tkPriv
    global tcl_platform
    if {($tkPriv(popup) != "") || ($tkPriv(postedMb) != "")} {
        tkMenuUnpost {}
    }
    tkPostOverPoint $menu $x $y $entry
    if {$tcl_platform(platform) == "unix"} {
        tkSaveGrabInfo $menu
        grab -global $menu
        set tkPriv(popup) $menu
        tk_menuSetFocus $menu;
    }
}

#
# end of file
