#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/main.tcl
#
# main source program for the SWB resegmentation tool
#

# set up the home path
#
global ISIP_TRANSCRIBER_HOME
set ISIP_TRANSCRIBER_HOME "$env(ISIP_TRANSCRIBER)/gui/src"

# source the combobox
#
source $ISIP_TRANSCRIBER_HOME/util.tcl
source $ISIP_TRANSCRIBER_HOME/widget.tcl
source $ISIP_TRANSCRIBER_HOME/combobox.tcl

# source global variables
#
source $ISIP_TRANSCRIBER_HOME/globals.tcl

# set up the display and principal key bindings
#
source $ISIP_TRANSCRIBER_HOME/display.tcl
source $ISIP_TRANSCRIBER_HOME/bindings.tcl

# the configuration options window
#
source $ISIP_TRANSCRIBER_HOME/config.tcl
source $ISIP_TRANSCRIBER_HOME/env.tcl

# commands pertaining to audio play
#
source $ISIP_TRANSCRIBER_HOME/audio.tcl

# updating the window display
#
source $ISIP_TRANSCRIBER_HOME/window.tcl
source $ISIP_TRANSCRIBER_HOME/brackets.tcl
source $ISIP_TRANSCRIBER_HOME/coords.tcl

# plotting and zooming
#
source $ISIP_TRANSCRIBER_HOME/zoom.tcl
source $ISIP_TRANSCRIBER_HOME/plot.tcl
source $ISIP_TRANSCRIBER_HOME/channel.tcl

# set up the list box
#
source $ISIP_TRANSCRIBER_HOME/list.tcl
source $ISIP_TRANSCRIBER_HOME/file.tcl
source $ISIP_TRANSCRIBER_HOME/load.tcl
source $ISIP_TRANSCRIBER_HOME/utter.tcl

# the verification mode
#
source $ISIP_TRANSCRIBER_HOME/verify.tcl

# save data
#
source $ISIP_TRANSCRIBER_HOME/save.tcl

# file selection menu [code courtesy Rick Duncan]
#
source $ISIP_TRANSCRIBER_HOME/filesel.tcl

# autofill facilities
#
source $ISIP_TRANSCRIBER_HOME/expand.tcl

# log and help functions
#
source $ISIP_TRANSCRIBER_HOME/lexicon.tcl
source $ISIP_TRANSCRIBER_HOME/log.tcl
source $ISIP_TRANSCRIBER_HOME/bookmark.tcl
source $ISIP_TRANSCRIBER_HOME/help.tcl

# shut down and exit
#
source $ISIP_TRANSCRIBER_HOME/quit.tcl

# initialize current time
#
global time_updated
set time_updated [clock seconds]

# start with updated windows
#
update

#
# end of file



