#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/log.tcl
#
# procedures to create the log window and manage log entries
#

# list of procedures:
#
#  log_proc {}
#  log_entry_proc {log_text}
#  log_view_proc {}
#

# procedure: log_proc
#
# arguments: none
#
# return: none
#
# procedure to create the log window
#
proc log_proc {} {

    # define globals
    #
    global ll
    set ll ".log"

    global transcriber_id
    global cspk_id
    global cutt_trans
    global logfile

    global transcriber_title
    global bg_col

    global loadflag

    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }

    # don't recreate the window, try to reuse existing one
    #
    if { [winfo exists $ll] == 1 } {
        wm deiconify $ll
        raise $ll
 
	# set the appropriate variable values
	#
	$ll.trans configure -text "Transcriber: $transcriber_id"
	$ll.utt configure -text "Utterance id: $cspk_id"
	$ll.mesg delete 1.0 end

    } else {
	
	# create a new window
	#
	toplevel $ll
	wm title $ll "$transcriber_title Comment Entry"
	wm geometry $ll "+300+300"
	wm focusmodel $ll active
	wm minsize $ll 400 275

	# make top and bottom frames
	#
	frame $ll.top0_f -borderwidth 1 -background $bg_col
	frame $ll.top1_f -borderwidth 1 -background $bg_col
	frame $ll.top2_f -borderwidth 1 -background $bg_col
	frame $ll.bot_f -borderwidth 1 -background $bg_col
	pack $ll.top0_f -side top -fill both
	pack $ll.top1_f $ll.top2_f -side top -fill both -expand true \
		-padx 1 -pady 1
	pack $ll.bot_f -side bottom -fill both -pady 2

	# subframes for transcription
	#
	frame $ll.top1a_f -background $bg_col
	frame $ll.top1b_f -background $bg_col
	pack $ll.top1a_f -fill both -in $ll.top1_f
	pack $ll.top1b_f -fill both -expand true -in $ll.top1_f

	# subframes for log message
	#
	frame $ll.top2a_f -background $bg_col
	frame $ll.top2b_f -background $bg_col
	pack $ll.top2a_f -fill both -in $ll.top2_f
	pack $ll.top2b_f -fill both -expand true -in $ll.top2_f

	# create the data space
	#
	label $ll.trans -text "Transcriber: $transcriber_id" -anchor w \
		-background $bg_col
	label $ll.utt -text "Utterance id: $cspk_id" -anchor w \
		-background $bg_col
	pack $ll.trans $ll.utt  -side top -fill both -expand true \
		-in $ll.top0_f

	label $ll.utrans -text "Transcription:" -anchor w \
		-background $bg_col
	text $ll.text -relief sunken -yscrollcommand "$ll.utt_scroll set" \
		-height 5 -width 60 -wrap word -background $bg_col
	scrollbar $ll.utt_scroll -command "$ll.text yview" -borderwidth 1 \
		-background $bg_col
	pack $ll.utrans -fill both -in $ll.top1a_f
	pack $ll.text -padx 1 -pady 1 -side left -fill both -expand true \
		-in $ll.top1b_f
	pack $ll.utt_scroll -side right -fill y -in $ll.top1b_f

	# create the log entry space
	#
	label $ll.msg_l -text "Enter your comment:" -anchor w \
		-background $bg_col
	text $ll.mesg -relief sunken -yscrollcommand "$ll.msg_scroll set" \
		-wrap word -height 5 -width 60 -background $bg_col
	scrollbar $ll.msg_scroll -command "$ll.mesg yview" -borderwidth 1 \
		-background $bg_col
	pack $ll.msg_l -fill both -in $ll.top2a_f
	pack $ll.mesg -padx 1 -pady 1 -side left -fill both -expand true \
		-in $ll.top2b_f
	pack $ll.msg_scroll -side right -fill y -in $ll.top2b_f

	# create control button
	#
	button $ll.enter -text "Enter" -width 10 -background $bg_col \
		-command {
	    
	    # read the log entry written by the transcriber
	    #
	    set log_text [string trim [$ll.mesg get 1.0 end]]
	    
	    # enter this in the log file
	    #
	    log_entry_proc $log_text

	    # clear current message
	    #
	    $ll.mesg delete 1.0 end
	    
	    # shut down log window
	    #
	    destroy $ll
	}
	pack $ll.enter -side left -padx 1 -pady 1 -in $ll.bot_f

	# create view log button
	#
	button $ll.view -text "View Comments" -width 10 -background $bg_col \
		-command {
	 
	    # display the log file in a window
	    #
	    log_view_proc
	    
	    # shut down log window
	    #
	    destroy $ll
	}

	# show this only if the file exists
	#
	if {[file exists $logfile] == 1} {
	    pack $ll.view -side left -padx 1 -pady 1 -in $ll.bot_f
	}

	# create resume log button
	#
	button $ll.resume -text "Resume" -width 10 -background $bg_col \
		-command {
	 
	    # resume with the last bookmark where the transcriber left off
	    #
	    set_comment_proc
	}

	# show this only if the file exists
	#
	if {[file exists $logfile] == 1} {
	    pack $ll.resume -side left -padx 1 -pady 1 -in $ll.bot_f
	}

	# bookmark button
	#
	button $ll.bookmark -text "Bookmark" -width 10 -background $bg_col \
		-command {
	    bookmark_entry_proc
	    destroy $ll
	}
	pack $ll.bookmark -side left -padx 1 -pady 1 -in $ll.bot_f
    
	# quit button
	#
	button $ll.cancel -text "Cancel" -width 10 -command "destroy $ll" \
		-background $bg_col
	pack $ll.cancel -side right -padx 1 -pady 1 -in $ll.bot_f
    }

    # remove white space from the transcription
    #
    set cutt_trans [string trim $cutt_trans]

    # enter text
    #
    $ll.text configure -state normal
    $ll.text delete 1.0 end
    $ll.text insert end $cutt_trans
    $ll.text configure -state disabled
}

# procedure: log_entry_proc
#
# arguments:
#  log_text: input string
#
# return: none
#
# procedure to write the log entry to file
#
proc log_entry_proc {log_text} {

    # declare globals
    #
    global logfile
    global transcriber_id
    global cspk_id
    global cutt_trans
    global audio_file

    # create the log file if it does not exist, otherwise open in
    # append mode
    #
    set fileptr ""
    if {[file exists $logfile] != 1} {
	set fileptr [open $logfile w]
    } else {
	set fileptr [open $logfile a]
    }

    # retrieve the current audiofile
    #
    set file ""
    set file $audio_file

    # make sure the log file is writable
    #
    if {[file writable $logfile] != 1} {
	warning_proc "Cannot write to the comment file $logfile. Please \
		make sure the file has write permissions."
	return
    }

    # write the info to the log file
    #
    puts $fileptr "###"
    puts $fileptr "Transcriber    : $transcriber_id"
    puts $fileptr "Utterance File : $file"
    puts $fileptr "Date           : [clock format [clock seconds]]"
    puts $fileptr "Transcription  : $cutt_trans"
    puts $fileptr "Comments       : $log_text\n"

    # close the file
    #
    close $fileptr
}

# procedure: log_view_proc
#
# arguments: none
#
# return: none
#
# procedure to view the log file
#
proc log_view_proc {} {

    # declare globals
    #
    global logfile
    
    global lv
    set lv ".log_view"

    global transcriber_title
    global bg_col

    # make sure the log file exists
    #
    if {[file exists $logfile] != 1} {
	warning_proc "Comment file is empty."
	return
    }

    # don't recreate the window, try to reuse existing one
    #
    if {[winfo exists $lv] == 1 } {
        wm deiconify $lv
        raise $lv

    } else {

        # start a new window
        #
        toplevel $lv
        wm title $lv "$transcriber_title View Comments"
        wm geometry $lv "+100+100"
	wm focusmodel $lv active

        # make a top and bottom frame
        #
        frame $lv.top_f -borderwidth 1 -relief ridge -height 400 -width 300 \
		-background $bg_col
        frame $lv.bot_f -borderwidth 1 -relief ridge -height 120 -width 300 \
		-background $bg_col
        pack $lv.top_f -fill both -expand true -side top
        pack $lv.bot_f -fill both -side bottom

        # create text-area for displaying the log messages
	#
	text $lv.mesg -relief sunken -yscrollcommand "$lv.llscroll set" \
                -wrap word -state disabled -width 72 -background $bg_col
	read_file_proc $lv.mesg $logfile
        scrollbar $lv.llscroll -command "$lv.mesg yview" -borderwidth 1 \
		-background $bg_col
        pack $lv.mesg -padx 1 -pady 1 -side left -fill both -expand true \
                -in $lv.top_f
        pack $lv.llscroll -side right -fill y -in $lv.top_f

	# create a button to refresh
	#
	button $lv.refresh -text "Refresh" -width 10 -background $bg_col \
		-command {
	    read_file_proc $lv.mesg $logfile
        }
	pack $lv.refresh -side left -fill both -padx 1 -pady 1 -in $lv.bot_f

	# create a button to dismiss
	#
	button $lv.quit -text "Dismiss" -width 10 -background $bg_col \
		-command {
            destroy $lv
        }

	pack $lv.quit -side right -fill both -padx 1 -pady 1 -in $lv.bot_f

        # key bindings
        #
        bind $lv <Return> {
            destroy $lv
        }
    }
}

#
# end of file
