#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/list.tcl
#
# procedures for managing the utterance lists and the listbox widget
# containing the list of utterances
#

# list of procedures:
#
#  fill_list_proc {}
#  reorder_proc {}
#  compare_proc {item1 item2}
#

# procedure: fill_list_proc
#
# arguments: none
#
# return: none
#
# set up the listbox with node ids for the given channel
#
proc fill_list_proc {} {

    # declare global variables
    #
    global current_time
    
    global audiolist

    global p

    # clear the listbox
    #
    $p.list delete 0 end

    # get the label headings
    #
    foreach item $audiolist {

	set ind [string last "/" $item]
	set ind [expr $ind + 1]
	set value [string range $item $ind end]
	$p.list insert end $value
    }
}

# procedure: reorder_proc
#
# arguments: none
#
# return: none
#
# procedure to reorder the utterance list and update the listbox
#
proc reorder_proc {} {

    # update the listbox
    #
    fill_list_proc
}

# procedure: compare_proc
#
# arguments:
#  item1: first utterance
#  item2: second utterance
#
# return: none
#
# comparison procedure for sorting utterances
#
proc compare_proc {item1 item2} {
    
    # compare the start and end times
    #
    foreach {cid1 uid1 spkr1 sex1 age1 start1 end1 trans1} $item1 {
	foreach {cid2 uid2 spkr2 sex2 age2 start2 end2 trans2} $item2 {

	    if {$start1 == $start2 } {
		if {$end1 == $end2} {
		    set value 0
		} elseif {$end1 < $end2} {
		    set value -1
		} else {
		    set value 1
		}
	    } elseif {$start1 < $start2} {
		set value -1
	    } else {
		set value 1
	    }
	}
    }

    # return the comparison result value
    #
    return $value
}

#
# end of file
