#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/help.tcl
#
# procedures to display online help
#

# list of procedures:
#
#  help_proc {}
#  help_item_proc {message}
#

# procedure: help_proc
#
# arguments: none
#
# return: none
#
# procedure to create a help window
#
proc help_proc {} {
   
    # declare globals
    #
    global help_default_file
    global help_keybind_file
    global help_transguide_file
    global help_directions_file

    global p
    global h

    global transcriber_title
    global bg_col

    # set h
    #
    set h ".help"

    # don't recreate the window, try to reuse existing one
    #
    if {[winfo exists $h] == 1 } {
        wm deiconify $h
        raise $h
	
    } else {

	# start a new window
	#
	toplevel $h
	wm title $h "$transcriber_title Help"
	wm geometry $h "+100+100"
	wm focusmodel $h active

	# make a top and bottom frame
	#
	frame $h.top_f -borderwidth 1 -relief ridge -height 400 -width 300 \
		-background $bg_col
	frame $h.bot_f -borderwidth 1 -relief ridge -height 120 -width 300 \
		-background $bg_col
	pack $h.top_f -fill both -expand true -side top
	pack $h.bot_f -fill both -side bottom

	# create text-area for displaying help
	#
	text $h.mesg -relief sunken -yscrollcommand "$h.hhscroll set" \
		-wrap word -state disabled -width 72 -background $bg_col
	read_file_proc $h.mesg $help_default_file
	scrollbar $h.hhscroll -command "$h.mesg yview" -borderwidth 1 \
		-background $bg_col
	pack $h.mesg -padx 1 -pady 1 -side left -fill both -expand true \
		-in $h.top_f
	pack $h.hhscroll -side right -fill y -in $h.top_f

	# create buttons for different help topics
	#
	button $h.key -text "Key Bindings" -width 10 -background $bg_col \
		-command {
	    read_file_proc $h.mesg $help_keybind_file
	    update
	}
	button $h.dir -text "Procedure" -width 10 -background $bg_col \
		-command {
	    read_file_proc $h.mesg $help_directions_file
	    update
	}
	button $h.quit -text "Dismiss" -width 10 -background $bg_col \
		-command {
	    destroy $h
	}

	pack $h.key $h.dir -side left -fill both \
		-padx 1 -pady 1 -in $h.bot_f
	pack $h.quit -side right -fill both -padx 1 -pady 1 -in $h.bot_f

	# key bindings
	#
	bind $h <Return> {
	    destroy $h
	}
    }
}

# procedure: help_item_proc
#
# arguments:
#  message: input string
#
# return: none
#
# procedure for itemized help
#
proc help_item_proc {message} {

    # declare globals
    #
    global p
    global hlp

    global transcriber_title
    global bg_col

    # set hlp
    #
    set hlp ".item_help"

    # don't recreate the window, try to reuse existing one
    #
    if {[winfo exists $hlp] == 1 } {
        wm deiconify $hlp
        raise $hlp
	
    } else {

	# start a new window
	#
	toplevel $hlp
	wm title $hlp "$transcriber_title Help"
	wm geometry $hlp "+200+200"
	wm focusmodel $hlp active

	# make a top and bottom frame
	#
	frame $hlp.top_f -borderwidth 1 -relief ridge -height 100 -width 100 \
		-background $bg_col
	frame $hlp.bot_f -borderwidth 1 -relief ridge -height 40 -width 100 \
		-background $bg_col
	pack $hlp.top_f -fill both -expand true -side top
	pack $hlp.bot_f -fill both -side bottom

	# create text-area for displaying help message
	#
	text $hlp.mesg -relief sunken -yscrollcommand "$hlp.hhscroll set" \
		-wrap word -state disabled -height 6 -width 60 \
		-background $bg_col
	scrollbar $hlp.hhscroll -command "$hlp.mesg yview" -borderwidth 1 \
		-background $bg_col
	pack $hlp.mesg -padx 1 -pady 1 -side left -fill both -expand true \
		-in $hlp.top_f
	pack $hlp.hhscroll -side right -fill y -in $hlp.top_f
	
	# create buttons
	#
	button $hlp.quit -text "Dismiss" -width 10 -background $bg_col \
		-command {
	    destroy $hlp
	}
	pack $hlp.quit -side right -fill both -padx 1 -pady 1 -in $hlp.bot_f

	# key bindings
	#
	bind $hlp <Return> {
	    destroy $hlp
	}
    }

    # update the help message
    #
    $hlp.mesg configure -state normal
    $hlp.mesg delete 1.0 end
    $hlp.mesg insert end "$message\n"
    $hlp.mesg configure -state disabled
}

#
# end of file
