#! /usr/local/bin/wish -f
# /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/globals.tcl
#
# this is the file to set up global environment variables
#

# declare global parameters and set values
#

# set the main display area
#
global p
set p ".main"

# set the word alignment window
#
global ww
set ww ".align"

# set the warning window
#
global wrn
set wrn ".warn"

# set the call selection window
#
global f
set f ".filesel"

# set the autofill window
#
global e
set e ".opt"

# title for the tool
#
global transcriber_title
set transcriber_title "The Transcriber"

# global environment
#
global env

# separater strings
#
global dir_sep
set dir_sep "\/"
global env_sep
set env_sep "\$"

# set the standard error constant
#
global std_error
set std_error "TRANSCRIBER ERROR FLAG"

# set the default combobox parameters
#
global cspk_noise
set cspk_noise ""
global cspk_mean
set cspk_mean ""
global cspk_age
set cspk_age ""
global cspk_sex
set cspk_sex ""
global cspk_name
set cspk_name ""
global cspk_id
set cspk_id ""
global cspk_type
set cspk_type ""


# define the general help files
#
global help_dir
set help_dir "$env(ISIP_TRANSCRIBER)/doc"
global help_default_file
set help_default_file "$help_dir/help_default.text"
global help_keybind_file
set help_keybind_file "$help_dir/help_keybind.text"
global help_transguide_file
set help_transguide_file "$help_dir/help_transguide.text"
global help_directions_file
set help_directions_file "$help_dir/help_directions.text"

# define the logos and images
#
global image_dir
set image_dir "$env(ISIP_TRANSCRIBER)/gui/images"
global isip_logo
set isip_logo "$image_dir/isip_logo.gif"
global prev_button
set prev_button "$image_dir/prev.xbm"
global prev_flag
set prev_flag 0
global next_button
set next_button "$image_dir/next.xbm"
global next_flag
set next_flag 0

# set some colors
#
global grey_col
set grey_col grey
global fg_col
set fg_col black
global bg_col
set bg_col white

# set some fonts
#
global font_0
global font_1
global font_2
global font_3

set font_0 "fixed"
set font_1 "*-times-medium-r-normal--*-170-*"
set font_2 "*-times-medium-r-normal--*-160-*"
set font_3 "*-times-medium-r-normal--*-150-*"

# define the utterance id variables
#
global chlabel
set chlabel "U"

# define the correct status variable
#
set correct_status 0

# define the background variable
#
set bg_noise 0

# define the transcription/word file name
#
global fname
set fname ""

# define the next and previous synchronization flags
#
global bgflag
set bgflag 0
global saveflag
set saveflag 0
global commentflag
set commentflag 0

# define the meaning and noise flags
#
global mean_flag
set mean_flag 0
global noise_flag
set noise_flag 0

# define the autoplay flag
#
global autoplay
set autoplay 1

# define the lock flags
#
global lock
set lock 0

# define the bookmarks flag
#
global bookmark_flag
set bookmark_flag 0
global bm_start
set bm_start 0

# define the call flag
#
global callflag
set callflag 0

# define verification flag
#
global verify_flag
set verify_flag 0

# define reload data flag
#
global reload_flag
set reload_flag 0

# define file selection flag
#
global filesel_flag
set filesel_flag 0

# define config procedure visited flag
#
global config_flag
set config_flag 0

# define transcription visited flag
#
global trans_flag
set trans_flag 0

# define transcription file parameters
#
global log_separator
set log_separator ";;;;;;;;;;"

global start_tag
set start_tag "start{"

global end_tag
set end_tag "}end"

global unknown_tag
set unknown_tag "< unknown >"

global state
set state $p.noise

# define word alignment mode flag
#
global word_mode
set word_mode 0
global word_zoom_mode
set word_zoom_mode 0
global word_stop
set word_stop 0

# parameters for time display
#
global wstart
set wstart 0.000000
global wend
set wend 0.000000
global bstart
set bstart $wstart
global bend
set bend $wend
global bdur
set bdur [expr $bend - $bstart]
global time
set time 0.000000

# parameters for previous utterance
#
global prev_ind
set prev_ind ""
global putt_start
set putt_start 0.000000
global putt_end
set putt_end 0.0000
global putt_trans
set putt_trans ""

# parameters for current utterance
#
global curr_ind
set curr_ind 0
global log_ind
set log_ind 0
global curr_word_ind
set curr_word_ind 0
global cutt_start
set cutt_start 0.000000
global cutt_end
set cutt_end 0.000000
global cutt_trans
set cutt_trans ""
global cutt_id
set cutt_id ""
global putt_audio
set putt_audio ""
global cutt_audio
set cutt_audio ""
global nutt_audio
set nutt_audio ""
global cutt_call
set cutt_call ""

# parameters for next utterance
#
global next_ind
set next_ind 1
global nutt_start
set nutt_start 0.000000
global nutt_end
set nutt_end 0.000000
global nutt_trans
set nutt_trans ""

# define the configuration parameters
#
global config_file
global audio_file
global trans0_file
global word0_file
global lexicon_file
global log_file

global num_utter
set num_utter 0

# set the config parameters by default to the example directory
#
global example_dir
set example_dir "$env(ISIP_TRANSCRIBER)/data"

set config_file ""
set audio_file ""
set trans0_file ""
set word0_file ""
set lexicon_file ""
set log_file ""

# define other global parameters
#
global loadflag
set loadflag 0

global pause_time
set pause_time 0.1

global transcriber_id
set transcriber_id ""

global conv_id
set conv_id "ISIP-ms98-"

global default_data_dir
set default_data_dir $example_dir

# autosave parameters
#
global time_updated
set time_updated 0

global autosave_time
set autosave_time 300

global host
set host [exec uname -n | cut -d. -f1]

global byte_swap
if {[exec uname -p] == "i386"} {
    set byte_swap 1
} else {
    set byte_swap 0
}

# autosave files
#
global autosave_dir
global auto_t0_file
global auto_w0_file
set auto_t0_file ""
set auto_w0_file ""

# define the audio play system params
#
global audio_play_device
set audio_play_device "x86"
global audio_server
set audio_server "speaker"

# define the audio-related variables
#
global current_channel
set current_channel 0
global num_channels
set num_channels 1
global sample_frequency
set sample_frequency 8000.0
global sample_num_bytes
set sample_num_bytes 2
global volume_ch0
set volume_ch0 1
global volume_ch1
set volume_ch1 1
global play_mode
set play_mode 0
global amplitude_gain
set amplitude_gain 1
global current_amplitude
set current_amplitude 1

# define the graphics window parameters
#
global current_time
set current_time 0
global maximum_time
set maximum_time 300
global zoom_min
set zoom_min 0.002

global window_start
set window_start 0.0
global window_end
set window_end $zoom_min
global window_duration
set window_duration $zoom_min

global bracket_start
set bracket_start $window_start
global bracket_end
set bracket_end $window_end
global bracket_duration
set bracket_duration $window_duration
global bracket_signal_start_line
global bracket_signal_end_line
global bracket_energy_start_line
global bracket_energy_end_line
global bracket_spec_start_line
global bracket_spec_end_line

# define plotting varibales for the energy plot widget
#
global window_len
set window_len 0.025
global frame_len
set frame_len 0.01
global preemph_coeff
set preemph_coeff 0.97
global preemph_flag
set preemph_flag 1
global preemphasis_display
set preemphasis_display "On"
global window_option
set window_option "hamming"
global window_size
set window_size 25
global rms_factor
set rms_factor 1.0
global energy_ht
set energy_ht 40
global signal_ht
set signal_ht 170
global contrast_d
set contrast_d 1
global current_contrast
set current_contrast 1
global brightness_d
set brightness_d 1000
global current_brightness
set current_brightness 1000
global fftlen_d
set fftlen_d 256

# define the plotting-related variables
#
global plot_width
set plot_width 490
global tscale_frame
set tscale_frame 0.01
global tscale_height
set tscale_height 10
global tscale_sep
set tscale_sep [expr 10 * $tscale_frame]
global sig_plot_0
global energy_plot_0
global spec_plot_0

# define the audio executable programs
#
global play_prog_dat
set play_prog_dat "$env(ISIP_TRANSCRIBER)/bin/$env(ISIP_BINARY)/isip_naplay"
global play_prog_ncd
set play_prog_ncd "auplay"
global play_prog_x86
set play_prog_x86 "audioplay"
global play_prog_sparc
set play_prog_sparc "audioplay"
global excise_signal_prog
set excise_signal_prog "$env(ISIP_TRANSCRIBER)/bin/$env(ISIP_BINARY)/excise_signal"

# list of utterances for each channel
#
global chan0_uttlist
set chan0_uttlist {}

# list of words for each channel
#
global chan0_wordlist
set chan0_wordlist {}

global word_index_list
set word_index_list {}

# tags for transcription
#
global silence_tag
set silence_tag "\[silence\]"

#
# end of file
