#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/file.tcl
#
# prodedures for managing the file list and the listbox widget
# containing the list of trancription, audio, log and word boundary files
#

# list of procedures:
#
#  file_list_proc {}
#  fill_options_proc {}
#

# procedure: file_list_proc
#
# arguments: none
#
# return: none
#
# set up the listbox with audio file id's
#
proc file_list_proc {} {

    # declare globals
    #
    global f

    global callfile_list

    # clear the listbox
    #
    $f.list delete 0 end

    # insert each label heading in the listbox
    #
    foreach item $callfile_list {
	set call_id [string trim $item]
	set ind [string last "/" $call_id]
	set call_id [string range $call_id [expr $ind +1] end]
	$f.list insert end $call_id
    }
}

# procedure: fill_options_proc
#
# arguments: list of options
#
# return: none
#
# procedure that fills the list box with all the options that match the focus
#
proc fill_options_proc {option_list} {

    # declare globals
    #
    global e

    # clear the listbox
    #
    $e.list delete 0 end    

    # insert each option in the listbox
    #
    foreach item $option_list {
	set optstr [string trim $item]
	$e.list insert end $optstr
    }
}

#
# end of file
