#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/env.tcl
#
# procedures to identify environment variables from input string and
# expand them from the system
#

# list of procedures:
#
#  expand_env_proc {instr}
#

# procedure: expand_env_proc
#
# arguments:
#  instr: input string
#
# return: a string containing the expanded pathname
#
# this procedure expands the global variables that are part of the input
# pathname and returns a fully-expanded pathname
#
proc expand_env_proc {instr} {

    # declare globals
    #
    global p
    global env
    global dir_sep
    global env_sep

    # the output string
    #
    set outstr ""

    # break the string into various sections
    #
    set instr [string trim $instr]
    set ind 0
    while {$ind >= 0} {
	
	# extract each subpath string
	#
	set ind [string first $dir_sep $instr]
	if {$ind < 0}  {
	    set var $instr
	} else {
	    set var [string range $instr 0 $ind]
	    set instr [string range $instr [expr $ind + 1] end]
	    set instr [string trim $instr]
	}
	set var [string trimright $var $dir_sep]

	# check if the subpath is an environment variable
	#
	if {[string index $var 0] == $env_sep} {
	    set var [string range $var 1 end]
	    set var "$env($var)"
	}
	set outstr [format "%s%s" $outstr $var]

	# add directory separator if required
	#
	if {$ind >= 0} {
	    set outstr [format "%s%s" $outstr $dir_sep]
	}
    }

    # return the expanded string and exit
    #
    return $outstr
}

#
# end of file
