#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/display.tcl
#
# this file sets up the main segmentation tool widgets
#

# declare global variables
#
global current_channel
global play_mode
global sig_plot_0
global energy_plot_0
global spec_plot_0

global bracket_signal_start_line
global bracket_signal_end_line
global bracket_energy_start_line
global bracket_energy_end_line
global bracket_spec_start_line
global bracket_spec_end_line

global trans0_file
global word0_file
global log_file
global audio_file
 
global trans_list
global audio_list
global word_list
global log_list

global curr_list_index

global correct_status
global bg_noise

global grammar
global nlresults
global results
global wavfile

global window_len
global frame_len
global rms_factor
global amplitude_gain

global preemph_coeff
global preemph_flag
global window_option 

global brightness_d
global contrast_d

global lock 
global autoplay

global unknown_tag
global silence_tag

global loadflag
global transcriber_id

global arraylist
global arrayindex

global signal_ht
global energy_ht

global p

# get rid of the old toplevel
#
wm withdraw .
catch {destroy $p}

# set new toplevel
#
toplevel $p
wm title $p "$transcriber_title"

# communicate with the window manager
#
wm protocol $p WM_DELETE_WINDOW {
    quit_proc
    exit
}
wm geometry $p "+0+0"
wm minsize $p 800 600

# create the base frames
#
frame $p.trans_f -borderwidth 1 -background $bg_col -relief flat \
	-height 600 -width 480
frame $p.ctrl_f -borderwidth 1 -background $bg_col -relief ridge \
	-height 600 -width 320

pack $p.trans_f -side left -fill both -expand true
pack $p.ctrl_f -side right -fill both

# create subframes for transcription area
#
frame $p.top_f -borderwidth 1 -relief ridge -height 280 -width 480 \
	-background $bg_col
frame $p.bot_f -borderwidth 1 -relief ridge -height 320 -width 480 \
	-background $bg_col

pack $p.top_f -side top -fill both -expand true -in $p.trans_f
pack $p.bot_f -side bottom -fill both -expand true -in $p.trans_f

# create logo subframe
#
frame $p.logo_f -borderwidth 1 -relief flat -height 40 -width 320 \
	-background $bg_col

pack $p.logo_f -padx 1 -pady 1 -side top -fill both -in $p.ctrl_f

# create subframes for tool control panel
#
frame $p.ctr1_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr2_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr3_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr4_0_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr4_1_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr4_2_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr4_3_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr6_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr7_1_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr7_2_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr7_3_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr7_4_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr7_5_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col
frame $p.ctr7_6_f -borderwidth 0 -relief flat -height 40 -width 320 \
	-background $bg_col

pack $p.ctr1_f $p.ctr2_f -padx 1 -pady 1 -side top -fill both -in $p.ctrl_f
pack $p.ctr3_f $p.ctr7_1_f $p.ctr7_2_f $p.ctr7_3_f $p.ctr7_4_f $p.ctr7_5_f \
	$p.ctr7_6_f $p.ctr4_0_f $p.ctr4_1_f $p.ctr4_2_f $p.ctr4_3_f \
	$p.ctr6_f -padx 1 -pady 1 -side top -fill both -in $p.ctrl_f

# creates subframe for utterance control panel
#
frame $p.utt_f -borderwidth 1 -relief flat -height 320 -width 320 \
	-background $bg_col
frame $p.utl_f -borderwidth 0 -relief flat -height 320 -width 120 \
	-background $bg_col
frame $p.utr_f -borderwidth 0 -relief flat -height 320 -width 200 \
	-background $bg_col
frame $p.utr1_f -borderwidth 0 -relief flat -height 280 -width 200 \
	-background $bg_col
frame $p.utr2_f -borderwidth 0 -relief flat -height 40 -width 200 \
	-background $bg_col

pack $p.utr1_f -padx 1 -side top -fill both -expand true -in $p.utr_f
pack $p.utr2_f -padx 1 -side top -fill both -in $p.utr_f
pack $p.utr_f -padx 1 -pady 1 -side right -fill both -expand true -in $p.utt_f
pack $p.utl_f -padx 1 -pady 1 -side left -fill both -in $p.utt_f -expand true
pack $p.utt_f -padx 1 -pady 1 -side top -fill both -expand true -in $p.ctrl_f

# create subframes for text area
#
frame $p.txt1a_f -borderwidth 1 -relief flat -height 10 -width 480 \
	-background $bg_col
frame $p.txt1b_f -borderwidth 1 -relief flat -height 10 -width 480 \
	-background $bg_col
frame $p.txt2a_f -borderwidth 1 -relief flat -height 10 -width 480 \
	-background $bg_col
frame $p.txt2b_f -borderwidth 1 -relief flat -height 20 -width 480 \
	-background $bg_col
frame $p.txt3a_f -borderwidth 1 -relief flat -height 10 -width 480 \
	-background $bg_col
frame $p.txt3b_f -borderwidth 1 -relief flat -height 10 -width 480 \
	-background $bg_col

pack $p.txt1a_f -fill both -in $p.bot_f
pack $p.txt1b_f -fill both -expand true -in $p.bot_f
pack $p.txt2a_f -fill both -in $p.bot_f
pack $p.txt2b_f -fill both -expand true -in $p.bot_f
pack $p.txt3a_f -fill both -in $p.bot_f
pack $p.txt3b_f -fill both -expand true -in $p.bot_f

# create subframes for graphics area
#
frame $p.time_f -borderwidth 1 -relief flat -height 40 -width 480 \
	-background $bg_col
frame $p.plot_f -borderwidth 0 -relief flat -height 260 -width 480 \
	-background $bg_col
frame $p.spec_f -borderwidth 0 -relief flat -height 130 -width 480 \
	-background $bg_col

pack $p.time_f -fill both -expand true -in $p.top_f
pack $p.plot_f -fill both -expand true -in $p.top_f
pack $p.spec_f -fill both -expand true -in $p.top_f

# create frame for log file display
#
frame $p.log_f -borderwidth 1 -relief ridge -height 30 -width 480 \
	-background $bg_col
frame $p.log1_f -borderwidth 0 -relief flat -height 10 -width 480 \
	-background $bg_col
frame $p.log2_f -borderwidth 0 -relief flat -height 10 -width 480 \
	-background $bg_col
frame $p.log3_f -borderwidth 0 -relief flat -height 10 -width 480 \
	-background $bg_col
pack $p.log1_f $p.log2_f $p.log3_f -fill both -padx 1 -pady 1 -in $p.log_f
pack $p.log_f -fill both -padx 1 -pady 1 -in $p.top_f

# add the buttons for control panel
#
button $p.load -text Load -width 6 -background $bg_col -command {    
    load_prompt_proc
}
button $p.config -text Config -width 6 -background $bg_col -command {
    config_proc
}
button $p.log -text Comment -width 6 -background $bg_col -command {
    log_proc
}
button $p.save -text Save -width 6 -background $bg_col -command {
    $p config -cursor watch
    save_proc
    $p config -cursor top_left_arrow
}
button $p.help -text Help -width 6 -background $bg_col -command {
    help_proc
}
button $p.quit -text Quit -width 6 -background $bg_col -command {
    quit_proc
}

# add the call selection, transcription lock and autoplay buttons
#
button $p.callsel -text "Call Sel" -width 6 -background $bg_col \
	-command {
    if {$filesel_flag == 0} {

	# display a warning message no config file has been loaded yet
	#
	warning_proc "Please make sure that you have loaded a configuration 
	file before you start using the call selection mechanism."
    } else {
	call_prompt_proc
    }
}
checkbutton $p.lock -text "Lock" -variable lock -width 6 \
	-background $bg_col -relief raised -command {

	# disable the ability to transcribe
	#
        if {$lock == 1} {
	$p.curr_trans configure -state disabled
	$p.clear configure -state disabled
	$p.copy configure -state disabled
	$p.ignore configure -state disabled
	$p.save configure -state disabled
	} else {
	    $p.curr_trans configure -state normal
	    $p.clear configure -state normal
	    $p.copy configure -state normal
	    $p.ignore configure -state normal
	    $p.save configure -state normal
	}   
}
checkbutton $p.auto -width 6 -text "Autoplay" -variable autoplay \
	-relief raised -background $bg_col 

# pack the buttons
#
pack $p.load $p.config $p.log -side left -padx 1 -pady 2 -fill both \
	-expand true -in $p.ctr1_f
pack $p.save $p.help $p.quit -side left -padx 1 -pady 2 -fill both \
	-expand true -in $p.ctr2_f
pack $p.callsel $p.lock $p.auto -side left -padx 1 -pady 2 -fill both \
	-expand true -in $p.ctr3_f

# add the transfile information
#
label $p.grammar_label -anchor w -text "Grammar:" -width 12 \
	-background $bg_col
text $p.grammar_entry -wrap word -relief flat -height 1 -state disabled \
	-background $bg_col -width 10
label $p.results_label -anchor w  -text "Results:" -width 12 \
	-background $bg_col
listbox $p.results_entry -height 2 -relief flat -background $bg_col -width 10 \
	-selectmode single -yscrollcommand "$p.results_scroll set"
scrollbar $p.results_scroll -command "$p.results_entry yview" -borderwidth 0 \
	 -background $bg_col
label $p.nlresults_label -anchor w -text "NL Results:" -width 12 \
	-background $bg_col
listbox $p.nlresults_entry -relief flat -height 2 -selectmode single \
	-background $bg_col -width 10 -yscrollcommand "$p.nlresults_scroll set"
scrollbar $p.nlresults_scroll -command "$p.nlresults_entry yview" \
	-borderwidth 0 -background $bg_col

# key bindings for the restuls listbox
#
bind $p.results_entry <Double-Button-1> {

    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }

    $p config -cursor watch

    # get the current selected index form the results listbox
    #
    set index 0
    catch { set index [lindex [$p.results_entry curselection] 0] }

    # get the current selected line form the results listbox
    #
    set result ""
    catch { set result [$p.results_entry get $index] }

    # insert the current selected line into the transcription box
    #
    if {$result != ""} {
	
	# clear the current transcription box
	#
	clear_trans_proc

	# revove the tag from the result
	#
	regsub -all {\]: } $result {} result
	regsub -all {[RESULT\[]} $result {} result
	regsub -all {[0123456789]} $result {} result

	# insert the result into the transcription box
	#
	$p.curr_trans insert end $result
    }

    $p config -cursor top_left_arrow
}

# pack the labels and frames
#
pack $p.grammar_label -side left -fill x -in $p.log1_f
pack $p.grammar_entry -side left -fill x -expand true -in $p.log1_f
pack $p.results_label -side left -fill x -in $p.log2_f
pack $p.results_entry -side left -fill x -expand true -in $p.log2_f
pack $p.results_scroll -side right -fill y -in $p.log2_f
pack $p.nlresults_label -side left -fill x -in $p.log3_f
pack $p.nlresults_entry -side left -fill x -expand true -in $p.log3_f
pack $p.nlresults_scroll -side right -fill y -in $p.log3_f

# define the combobox widgets
#
set noise [combobox $p.noise -labeltext "Noise: " -labelwidth 11 \
	-labelanchor w -textvariable cspk_noise -click single \
	-command {verify_noise_proc} -width 12 \
	-list {{Low} {High} {Unknown}} -font $font_3 -height 20 -width 25]
set mean [combobox $p.mean -labeltext "Meaning: " -labelwidth 11 \
	-labelanchor w -textvariable cspk_mean -command {verify_mean_proc} \
	-click single -width 12 -list {{Correct} {Incorrect} {Unknown}} \
	-font $font_3 -height 20 -width 25] 
set age [combobox $p.age -labeltext "Age: " -labelwidth 11 -labelanchor w \
	-textvariable cspk_age -command {setage_proc} -click single \
	-width 12 -list {{Adult} {Adolescent} {Child} {Unknown}} \
	 -font $font_3 -height 20 -width 25]
set gender [combobox $p.gender -labeltext "Gender: " -labelwidth 11 \
	-labelanchor w -textvariable cspk_sex -command {setsex_proc} \
	-click single -width 12 -list {{Male} {Female} {Unknown}} \
	 -font $font_3 -height 20 -width 25] 
set type [combobox $p.type -labeltext "Type: " -labelwidth 11 -labelanchor w \
	-textvariable cspk_type -command {settype_proc} -click single \
	-width 12 -list {{Native} {NonNative} {Unknown}} \
	 -font $font_3 -height 20 -width 25] 

# pack the combobox widgets
#
pack $noise -side left -expand true -fill both -in $p.ctr7_1_f
pack $mean -side left -expand true -fill both -in $p.ctr7_2_f
pack $age -side left -expand true -fill both -in $p.ctr7_3_f
pack $gender -side left -expand true -fill both -in $p.ctr7_4_f
pack $type -side left -expand true -fill both -in $p.ctr7_5_f

label $p.id -anchor w -text "ID: " -width 11 -background $bg_col 
text $p.id_entry -relief sunken -height 1 -width 10 -background $bg_col
pack $p.id -side left -fill both -in $p.ctr7_6_f
pack $p.id_entry -side left -fill both -expand true -in $p.ctr7_6_f

# add the volume control
#
label $p.volume_label -justify left -text "Volume:" -width 11 \
	-anchor w -background $bg_col    
scale $p.volume0 -variable volume_ch0 -from 0 -to 5 -digits 0 \
	-resolution 0.2 -showvalue false -orient horiz -width 10 \
	-sliderlength 20 -background $bg_col -command {volume_proc 0}
pack $p.volume_label -side left -fill both -in $p.ctr4_0_f
pack $p.volume0 -side left -fill both -expand true -in $p.ctr4_0_f

# add the amplitude scale factor
#
label $p.gain_label -background $bg_col -anchor w -text "Amplitude:" -width 11
scale $p.gain_scale -variable amplitude_gain -from 0 -to 5 -digits 0 \
	-resolution 0.2 -showvalue false -orient horiz -width 10 \
	-sliderlength 20 -background $bg_col -command {update_gain_proc}
pack $p.gain_label -side left -fill both -in $p.ctr4_1_f
pack $p.gain_scale -side left -fill both -expand true -in $p.ctr4_1_f

# add the brightness scale factor
#
label $p.brt_label -background $bg_col -anchor w -text "Brightness:" -width 11
scale $p.brt_scale -variable brightness_d -from 0 -to 5000 -digits 0 \
	-bigincrement 0 -resolution 0.2 -showvalue false -orient horiz \
	-width 10 -sliderlength 20 -background $bg_col \
	-command {update_brightness_proc}
pack $p.brt_label -side left -fill both -in $p.ctr4_2_f
pack $p.brt_scale -side left -fill both -expand true -in $p.ctr4_2_f

# add the contrast scale factor
#
label $p.con_label -background $bg_col -anchor w -text "Contrast:" -width 11
scale $p.con_scale -variable contrast_d -from 0 -to 5 -digits 0 \
	-resolution 0.2 -showvalue false -orient horiz -width 10 \
	-sliderlength 20 -background $bg_col -command {update_contrast_proc}
pack $p.con_label -side left -fill both -in $p.ctr4_3_f
pack $p.con_scale -side left -fill both -expand true -in $p.ctr4_3_f

# add the utterance play buttons
#
label $p.qplay_label -background $bg_col -anchor w -text "QuickPlay:" -width 11
button $p.play_2b -text -2 -width 1 -command {play_utt_proc -2} \
	-background $bg_col
button $p.play_1b -text -1 -width 1 -command {play_utt_proc -1} \
	-background $bg_col
button $p.play_0 -text 0 -width 1 -command {play_utt_proc 0} \
	-background $bg_col
button $p.play_1a -text +1 -width 1 -command {play_utt_proc +1} \
	-background $bg_col
button $p.play_2a -text +2 -width 1 -command {play_utt_proc +2} \
	-background $bg_col
pack $p.qplay_label -side left -fill both -expand true -in $p.ctr6_f
pack $p.play_2b $p.play_1b $p.play_0 $p.play_1a $p.play_2a -side left \
	-fill both -expand true -in $p.ctr6_f

# add the buttons for utterance manipulation
#
button $p.play -text "Play Utter" -width 8 -background $bg_col \
	-command {

    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }

    play_utt_proc 0
}
button $p.verify -text "Play Call" -width 8 -background $bg_col \
	-command {

    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }

    verify_proc
    set callflag 0
    update
}
button $p.lexicon -text "Lexicon" -width 8 -background $bg_col \
	-command {

    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }

    $p config -cursor watch
    update
    lexicon_proc
    $p config -cursor top_left_arrow
}
button $p.clear -text "Clear" -width 8 -background $bg_col -command {

    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }

    $p config -cursor watch
    clear_trans_proc
    $p config -cursor top_left_arrow
}
button $p.ignore -text "Ignore" -width 8 -background $bg_col \
	-command {

    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }

    # clear the current contents
    #
    clear_trans_proc
    
    # include the silence tag in the trancription box
    #
    $p.curr_trans insert end $silence_tag
}
button $p.copy -text "Copy" -width 8 -background $bg_col -command {

    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }

    # get the current selected index form the results listbox
    #
    set index 0
    catch { set index [lindex [$p.results_entry curselection] 0] }

    # get the current selected line form the results listbox
    #
    set result ""
    catch { set result [$p.results_entry get $index] }

    # insert the current selected line into the transcription box
    #
    if {$result != ""} {
	
	# clear the current transcription box
	#
	clear_trans_proc

	# revove the tag from the result
	#
	regsub -all {\]: } $result {} result
	regsub -all {[RESULT\[]} $result {} result
	regsub -all {[0123456789]} $result {} result

	# insert the result into the transcription box
	#
	$p.curr_trans insert end $result
    }
}

pack $p.play $p.verify $p.lexicon $p.clear $p.copy $p.ignore -side top \
	-padx 1 -pady 5 -expand true -fill both -in $p.utl_f 

# add the listbox stuff
#
listbox $p.list -selectmode single -yscrollcommand "$p.yscroll set"\
	-width 12 -background $bg_col 
scrollbar $p.yscroll -command "$p.list yview" -background $bg_col 
pack $p.list -side left -padx 1 -pady 1 -fill both -expand true -in $p.utr1_f
pack $p.yscroll -side right -padx 1 -pady 1 -fill y -in $p.utr1_f

# key bindings for the listbox
#
bind $p.list <Double-Button-1> {

    if {[verify_utt_proc] == 0} {

	catch { $p.list selection clear 0 end }
	catch { $p.list selection set $curr_ind }
	return
    }

    $p config -cursor watch
    catch { set index [lindex [$p.list curselection] 0] }
    set_utt_proc
    set_current_proc $index
    $p config -cursor top_left_arrow
}
bind $p.list <Enter> {

    catch { $p.list selection clear 0 end }
    catch { $p.list selection set $curr_ind }
}

# add the prev/next utterance buttons
#
button $p.prev -bitmap "@$prev_button" -background $bg_col -command {
    $p config -cursor watch
    prev_utt_proc
    $p config -cursor top_left_arrow
}
button $p.next -bitmap "@$next_button" -background $bg_col -command {
    $p config -cursor watch
    next_utt_proc
    $p config -cursor top_left_arrow
}
pack $p.prev -side left -padx 1 -pady 1 -fill both -in $p.utr2_f
pack $p.next -side right -padx 1 -pady 1 -fill both -in $p.utr2_f

# add the logo stuff
#
label $p.title -text "$transcriber_title" -background $bg_col -width 10
image create photo logo -file "$isip_logo" -format gif -palette 255/255/255
label $p.logo -image logo -background $bg_col
pack $p.title $p.logo -side left -padx 1 -fill x -expand true -in $p.logo_f

# add the text areas
#
text $p.prev_trans -relief sunken -yscrollcommand "$p.prev_scroll set" \
	-wrap word -background $grey_col -state disabled \
	 -height 1 -width 10 -font $font_2
text $p.curr_trans -relief sunken -yscrollcommand "$p.curr_scroll set" \
	-wrap word -background $bg_col -state normal \
	-height 1 -width 10 -font $font_1
text $p.next_trans -relief sunken -yscrollcommand "$p.next_scroll set" \
	-wrap word -background $grey_col -state disabled \
	-height 1 -width 10 -font $font_2
scrollbar $p.prev_scroll -command "$p.prev_trans yview" -borderwidth 1 \
	 -background $bg_col
scrollbar $p.next_scroll -command "$p.next_trans yview" -borderwidth 1 \
	 -background $bg_col
scrollbar $p.curr_scroll -command "$p.curr_trans yview" -borderwidth 1 \
	 -background $bg_col

# add labels for each text area
#
label $p.cid_label -text "Audio File: $cutt_audio" -background $bg_col \
	-width 40 -anchor w
label $p.csession_label -text "Call: $cutt_call" -background $bg_col \
	-anchor w
label $p.pid_label -text "Audio File: $putt_audio" -background $bg_col \
	-width 30 -anchor w
label $p.nid_label -text "Audio File: $nutt_audio" -background $bg_col \
	-width 30 -anchor w

pack $p.pid_label -side left -fill both -in $p.txt1a_f
pack $p.prev_trans -side left -fill both -expand true -in $p.txt1b_f
pack $p.prev_scroll -side right -fill y -in $p.txt1b_f

pack $p.cid_label $p.csession_label -side left -fill both -in $p.txt2a_f
pack $p.curr_trans -side left -fill both -expand true -in $p.txt2b_f
pack $p.curr_scroll -side right -fill y -in $p.txt2b_f

pack $p.nid_label -side left -fill both -in $p.txt3a_f
pack $p.next_trans -side left -fill both -expand true -in $p.txt3b_f
pack $p.next_scroll -side right -fill y -in $p.txt3b_f

# create the graphics pop-up menu
#
menu $p.menu_graphics -relief ridge -title "Graphics Options" \
	-background $bg_col
$p.menu_graphics add command -label "Audio Play" \
	-background $bg_col -font $font_3 -state disabled -command {}
$p.menu_graphics add command -label "Play between marks" \
	-command {
    set play_mode 0
    play_brackets_proc
    set play_mode $current_channel
}
$p.menu_graphics add command -label "Play window contents" \
	-command {
    set play_mode 0
    play_window_proc
    set play_mode $current_channel
}
$p.menu_graphics add separator
$p.menu_graphics add command -label "Zoom" -background $bg_col \
	-font $font_3 -state disabled -command {}
$p.menu_graphics add command -label "Zoom brackets" -accelerator "Alt+b" \
	-command {
    zoom_brackets_proc 
}
$p.menu_graphics add command -label "Zoom in" -accelerator "Alt+Down" \
	-command {
    $p config -cursor watch
    zoom_in_proc
    $p config -cursor top_left_arrow
}
$p.menu_graphics add command -label "Zoom out" -accelerator "Alt+Up" \
	-command {
    $p config -cursor watch
    zoom_out_proc
    $p config -cursor top_left_arrow
}
$p.menu_graphics add command -label "Zoom full" -accelerator "Alt+z" \
	-command {
    $p config -cursor watch
    zoom_full_proc
    $p config -cursor top_left_arrow
}
$p.menu_graphics add separator
$p.menu_graphics add command -label "Misc" -background $bg_col \
	-font $font_3 -state disabled -command {}
$p.menu_graphics add command -label "Set bookmark" -accelerator "Alt+o" \
	-command {
    bookmark_proc
}
$p.menu_graphics add command -label "Quit" -accelerator "Alt+q" \
	-command "quit_proc"

# set up the canvas for the wave plot
#
canvas $p.energy0_plot -relief flat -height 40 -width 480 -borderwidth 1 \
	-background $bg_col
pack $p.energy0_plot -fill both -padx 2 -pady 2 -in $p.plot_f

canvas $p.chan0_plot -relief flat -height 170 -width 480 -borderwidth 1 \
	-background $bg_col
pack $p.chan0_plot -fill both -padx 2 -pady 2 -in $p.plot_f

canvas $p.spec0_plot -relief flat -height 80 -width 480 -borderwidth 1 \
	-background $bg_col
pack $p.spec0_plot -fill both -padx 2 -pady 2 -in $p.spec_f

canvas $p.trn_plot -relief ridge -height 20 -width 480 -background $bg_col
# pack $p.trn_plot -padx 1 -pady 1 -fill both -in $p.plot_f

# set up time labels
#
label $p.dur_l -justify left -anchor w -text "W: \[$wstart , $wend\] \
	B: \[$bstart , $bend :: $bdur\] T: \[$time\]" \
	-width 88 -background $bg_col
pack $p.dur_l -side left -fill both -in $p.time_f

# set the energy plot widget
#
set energy_plot_0 [$p.energy0_plot create energy_plot 0 0 \
	-num_chan $num_channels -amp_scale $amplitude_gain \
	-num_bytes $sample_num_bytes \
	-swap_bytes $byte_swap -display_chan 0 -use_preemph $preemph_flag \
	-sample_freq $sample_frequency -start_time 0.0 -winlen $window_len \
	-filter $window_option -rms_scale $rms_factor \
	-end_time 0.0 -framelen $frame_len -preemph_coeff $preemph_coeff \
	-borderwidth 0 -relief flat]

# set the signal plot widget
#
set sig_plot_0 [$p.chan0_plot create signal_plot 0 0 \
	-num_chans $num_channels -num_bytes $sample_num_bytes \
	-swap_bytes $byte_swap -display_chan 0 \
	-sample_freq $sample_frequency -start_time 0.0 \
	-end_time 0.0 -gain_factor $amplitude_gain \
	-borderwidth 0 -relief flat]

# set the spectrogram plot widget
#
set spec_plot_0 [$p.spec0_plot create spectrogram_plot 0 0 \
	-num_chan $num_channels  -contrast $contrast_d \
	-num_bytes $sample_num_bytes -brightness $brightness_d \
	-swap_bytes $byte_swap -display_chan 0 -use_preemph $preemph_flag \
	-sample_freq $sample_frequency -start_time 0.0 -winlen $window_len \
	-filter $window_option -end_time 0.0 -framelen $frame_len \
	-preemph_coeff $preemph_coeff -borderwidth 0 -relief flat]

# if the locks are enabled from the start modify button status
#
if {$lock == 1} {
    
    # if both locks are active disable corresponding buttons
    #
    $p.curr_trans configure -state disabled
    $p.clear configure -state disabled
    $p.save configure -state disabled
}

# set the initial bracket lines
#
set bracket_signal_start_line [$p.chan0_plot create line 0 0 0 \
	$signal_ht -width 1.0]
set bracket_signal_end_line [$p.chan0_plot create line 0 0 0 \
	$signal_ht -width 1.0]

set bracket_energy_start_line [$p.energy0_plot create line 0 0 0 \
	$energy_ht -width 1.0]
set bracket_energy_end_line [$p.energy0_plot create line 0 0 0 \
	$energy_ht -width 1.0]

set bracket_spec_start_line [$p.spec0_plot create line 0 0 0 \
	[winfo height $p.spec0_plot] -width 1.0]
set bracket_spec_end_line [$p.spec0_plot create line 0 0 0 \
	[winfo height $p.spec0_plot] -width 1.0]

#
# end of file
