#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/coords.tcl
#
# procedures to determine the space and time coordinates
#

# list of procedures:
#
#  get_start_coords {x_in y_in}
#  get_end_coords {x_in y_in}
#  get_time_proc {x_in y_in}
#  display_time_proc {}
#

# procedure: get_start_coords
#
# arguments:
#  x_in: x coordinate
#  y_in: y coordinate
#
# return: none
#
# procedure to get the space coordinates of the first mouse click
#
proc get_start_coords {x_in y_in} {
    
    # set global variables
    #
    global p

    global current_time
    global window_start
    global window_end
    global window_duration
    global bracket_start
    global bracket_end
    global bracket_duration
    global plot_width
    global energy_ht
    global signal_ht
    global bracket_signal_start_line
    global bracket_signal_end_line
    global bracket_energy_start_line
    global bracket_energy_end_line
    global bracket_spec_start_line
    global bracket_spec_end_line
 
    # make sure that the x and y are on the canvas...
    #
    if {$x_in < 0} { 
        set x 0
    } elseif {$x_in > $plot_width} {
        set x $plot_width
    } else {
        set x $x_in
    }
    
    # set the start time based on the position on the screen
    #
    set bracket_start [eval expr ($window_duration / $plot_width) \
	    * $x + $window_start]
    set current_time $bracket_start
    
    if {$bracket_start > $bracket_end} {
	set tmp $bracket_end
	set bracket_end $bracket_start
	set bracket_start $tmp
    }
    
    # draw a line at the start time
    #
    $p.chan0_plot coords $bracket_signal_start_line $x 0 $x \
	    [winfo height $p.chan0_plot]
    $p.energy0_plot coords $bracket_energy_start_line $x 0 $x \
	    [winfo height $p.energy0_plot]
    $p.spec0_plot coords $bracket_spec_start_line $x 0 $x \
	    [winfo height $p.spec0_plot]

    # update the screen
    #
    display_time_proc
}

# procedure: get_end_coords
#
# arguments:
#  x_in: x coordinate
#  y_in: y coordinate
#
# return: none
#
# procedure to get the space coordinates of the mouse release
#
proc get_end_coords {x_in y_in} {
    
    # set global variables
    #
    global p
    
    global current_time
    global window_start
    global window_end
    global window_duration
    global bracket_start
    global bracket_end
    global bracket_duration
    global plot_width
    global energy_ht
    global signal_ht
    global bracket_signal_start_line
    global bracket_signal_end_line
    global bracket_energy_start_line
    global bracket_energy_end_line
    global bracket_spec_start_line
    global bracket_spec_end_line
    global word_mode

    # make sure that the x and y are on the canvas...
    #
    if {$x_in > $plot_width} {
        set x $plot_width
    } elseif {$x_in >= 0} { 
        set x $x_in
    } else {
        set x 0
    }
    
    # set the end time based on the position on the screen
    #
    set bracket_end [eval expr ($window_duration / $plot_width) \
	    * $x + $window_start]
    set current_time $bracket_end
	
    if {$bracket_start > $bracket_end} {
	set tmp $bracket_end
	set bracket_end $bracket_start
	set bracket_start $tmp
    }
	
    # get the coordinates of the start and end markers
    #
    set start_coords [$p.chan0_plot coords $bracket_signal_start_line]
    set end_coords [$p.chan0_plot coords $bracket_signal_end_line]
    
    # draw a line at the start time
    #
    $p.chan0_plot coords $bracket_signal_start_line \
	    [lindex $start_coords 0] [lindex $start_coords 1] \
	    [lindex $start_coords 2] [lindex $start_coords 3]
    
    # draw a line at the end time
    #
    $p.chan0_plot coords $bracket_signal_end_line \
	    [lindex $end_coords 0] [lindex $end_coords 1] \
	    [lindex $end_coords 2] [lindex $end_coords 3]

    # get the coordinates of the start and end markers
    #
    set start_coords [$p.energy0_plot coords $bracket_energy_start_line]
    set end_coords [$p.energy0_plot coords $bracket_energy_end_line]
    
    # draw a line at the start time
    #
    $p.energy0_plot coords $bracket_energy_start_line \
	    [lindex $start_coords 0] [lindex $start_coords 1] \
	    [lindex $start_coords 2] [lindex $start_coords 3]
    
    # draw a line at the end time
    #
    $p.energy0_plot coords $bracket_energy_end_line \
	    [lindex $end_coords 0] [lindex $end_coords 1] \
	    [lindex $end_coords 2] [lindex $end_coords 3]

    # get the coordinates of the start and end markers
    #
    set start_coords [$p.spec0_plot coords $bracket_spec_start_line]
    set end_coords [$p.spec0_plot coords $bracket_spec_end_line]
    
    # draw a line at the start time
    #
    $p.spec0_plot coords $bracket_spec_start_line \
	    [lindex $start_coords 0] [lindex $start_coords 1] \
	    [lindex $start_coords 2] [lindex $start_coords 3]
    
    # draw a line at the end time
    #
    $p.spec0_plot coords $bracket_spec_end_line \
	    [lindex $end_coords 0] [lindex $end_coords 1] \
	    [lindex $end_coords 2] [lindex $end_coords 3]
    
    # set the duration of the bracketed region
    #
    set bracket_duration [eval expr abs($bracket_end - $bracket_start)]

    # update the screen
    #
    display_time_proc
}

# procedure: get_time_proc
#
# arguments:
#  x_in: x coordinate
#  y_in: y coordinate
#
# return: none
#
# procedure to handle mouse movement in canvas
#
proc get_time_proc {x_in y_in} {
    
    # set global variables
    #
    global current_time
    global window_duration
    global plot_width
    global window_start
    
    global p

    # set the current time to the point where the mouse is
    #
    set current_time [eval expr ($window_duration / $plot_width) \
	    * $x_in + $window_start]

    # update the screen
    #
    display_time_proc
}

# procedure: display_time_proc
#
# arguments: none
#
# return: none
#
# procedure to set the time-info and display it dynamically
#
proc display_time_proc {} {

    # declare globals
    #
    global bstart
    global bend
    global bdur
    global wstart
    global wend
    global time
    
    global window_start
    global window_end
    global bracket_start
    global bracket_end
    global current_time
    
    global p

    # set the time display variables
    #
    set wstart [format "%.6f" $window_start]
    set wend [format "%.6f" $window_end]
    set bstart [format "%.6f" $bracket_start]
    set bend [format "%.6f" $bracket_end]
    set bdur [format "%.6f" [expr $bracket_end - $bracket_start]]
    set time [format "%.6f" $current_time]

    # find the absolute value of the duration
    #
    if {$bdur < 0} {
	set bdur [expr abs($bdur)]
    }

    # update the time display label
    #
    $p.dur_l configure -text "W: \[$wstart , $wend\] B: \[$bstart , \
	    $bend :: $bdur\] T: \[$time\]"

    # update the screen display
    #
    update
}

#
# end of file
