#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/config.tcl 
# 
# procedures to set the configuration parameters for the transcriber
#

# list of procedures:
#
#  call_prompt_proc {}
#  next_call_proc {}
#  prev_call_proc {}
#  load_prompt_proc {}
#  load_cfgfile_proc {}
#  speaker_sel_proc {}
#  update_log_proc {}
#  update_proc {}
#  update_all_proc {}
#  config_proc {}
#  config_ok_proc {}
#  config_reload_proc {}
#  config_set_proc {}
#

# procedure: call_prompt_proc
#
# arguments: none
#
# return: none
#
# procedure that runs the call selection mechanism and allows the user to
# quickly select calls form a list
#
proc call_prompt_proc {} {

    # declare globals
    #
    global p
    global f

    global cfg
    set f ".filesel"

    global curr_call_index
    global callfile_list

    global transcriber_title
    global bg_col

    global filesel_flag
    global config_flag

    global ind

    # don't recreate the window, try to reuse existing one
    #
    if {[winfo exists $f] == 1 } {
        wm deiconify $f
        raise $f
    } else {
	
	# create a new window
	#
	toplevel $f
        wm title $f "$transcriber_title Call Selection"
        wm geometry $f "+100+100"
	wm minsize $f 375 175
	wm focusmodel $f active
    
	# make the top and bottom frames
	#		
	frame $f.fsell_f -borderwidth 0 -relief flat -height 360 -width 120 \
		-background $bg_col 
	frame $f.fsl_f -borderwidth 0 -relief flat -height 360 -width 200 \
		-background $bg_col
	frame $f.fsl1_f -borderwidth 0 -relief flat -height 300 -width 200 \
		-background $bg_col

	pack $f.fsl1_f -padx 1 -side top -fill both -expand true -in $f.fsl_f
	pack $f.fsl_f -padx 1 -pady 1 -side right -fill both -expand true
	pack $f.fsell_f -padx 1 -pady 1 -side left -fill both 

	# add the listbox stuff
	#
	listbox $f.list -selectmode single -yscrollcommand "$f.yscroll set"\
		-background $bg_col -width 40
	scrollbar $f.yscroll -command "$f.list yview" -background $bg_col 
	pack $f.list -side left -padx 1m -pady 1m -fill both -expand true \
		-in $f.fsl1_f
	pack $f.yscroll -side right -padx 1m -pady 1m -fill y -in $f.fsl1_f

	# key bindings for the listbox
	#
	bind $f.list <Double-Button-1> {

	    # retrieve the index of the file selected
	    #
	    catch { set ind [lindex [$f.list curselection] 0] }
	    $p configure -cursor watch
	    $p configure -cursor top_left_arrow

	    # save and switch to the indexed file
	    #
	    save_proc
	    file_switch_proc

	    # activate the list box
	    #
	    catch { $f.list selection clear 0 end }
	    catch { $f.list see $curr_call_index }
	    catch { $f.list selection set $curr_call_index }
	}

	# fill the list box
	#
	file_list_proc
    
	# activate the list box
	#
	catch { $f.list selection clear 0 end }
	catch { $f.list see $curr_call_index }
	catch { $f.list selection set $curr_call_index }
	
	# add the prev/next/ok/dismiss buttons
	#
	button $f.prev -text "Previous" -background $bg_col -command {
	    prev_call_proc
	}
	button $f.next -text "Next" -background $bg_col -command {
	    next_call_proc
	}
	button $f.done -text "OK" -background $bg_col -command {

	    catch { set ind [lindex [$f.list curselection] 0] }

	    # save and switch to the indexed file
	    #
	    save_proc
	    file_switch_proc

	    # activate the list box
	    #
	    catch { $f.list selection clear 0 end }
	    catch { $f.list see $curr_call_index }
	    catch { $f.list selection set $curr_call_index }
	}
	button $f.cancel -text "Dismiss" -background $bg_col -command {
	    destroy $f
	}

	# event to view the current list box index
	#
	bind $f.list <Enter> {
	    catch { $f.list selection clear 0 end }
	    catch { $f.list selection set $curr_call_index }
	}

	pack $f.prev -side top -padx 1m -pady 1m -fill both -in $f.fsell_f
	pack $f.next -side top -padx 1m -pady 1m -fill both -in $f.fsell_f
	pack $f.done -side top -padx 1m -pady 1m -fill both -in $f.fsell_f
	pack $f.cancel -side top -padx 1m -pady 1m -fill both -in $f.fsell_f
    }
}

# procedure: next_call_proc
#
# arguments: none
#
# return: none
#
# procedure that loads the next call parameters
#
proc next_call_proc {} {

    # declare globals
    #
    global f

    global ind
    global curr_call_index
    global callfile_list
    
    global bgflag
    global saveflag
    global commentflag

    if {$bgflag == 0} {

	# set the background flag
	#
	set bgflag 1

	if {[winfo exists $f] == 1 } {
	    
	    # load the parameters of the next file
	    #
	    $f config -cursor watch
	    $f config -cursor top_left_arrow
	}
	
	# display a warning message if the end of session has been reached
	#
	if {[expr $curr_call_index + 1] == [llength $callfile_list]} {

	    bell
	    warning_proc "You have reached the end of the call"
	    set bgflag 0
	    return
	}
	
	set ind [expr $curr_call_index + 1]
	
	# save and switch to the indexed file
	#
	save_proc

	# wait for the save procedure to complete execution
	#
	while {$saveflag == 1} {
	    continue
	}

	# load the new file parameters
	#
	file_switch_proc
	
	if {[winfo exists $f] == 1 } {

	    # activate the list box
	    #
	    catch { $f.list selection clear 0 end }
	    catch { $f.list see $curr_call_index }
	    catch { $f.list selection set $curr_call_index }
	}

	# wait for the bookmark procedure to complete execution
	#
	while {$commentflag == 1} {
	    continue
	}
	
	# reset the background flag
	#
	set bgflag 0
    }
}
    
# procedure: prev_call_proc
#
# arguments: none
#
# return: none
#
# procedure that loads the previous call parameters
#
proc prev_call_proc {} {
    
    # declare globals
    #
    global f

    global ind
    global curr_call_index

    global bgflag
    global saveflag
    global commentflag

    if {$bgflag == 0} {

	# set the background flag
	#
	set bgflag 1

	if {[winfo exists $f] == 1 } {
	    
	    # load the parameters of the previous file
	    #
	    $f config -cursor watch
	    $f config -cursor top_left_arrow
	}

	set ind [expr $curr_call_index - 1]
	
	# save and switch to the indexed file
	#
	save_proc

	# wait for the save procedure to complete execution
	#
	while {$saveflag == 1} {
	    continue
	}

	# load the new file parameters
	#
	file_switch_proc
	
	if {[winfo exists $f] == 1 } {    
	    
	    # activate the list box
	    #
	    catch { $f.list selection clear 0 end }
	    catch { $f.list see $curr_call_index }
	    catch { $f.list selection set $curr_call_index }
	}

	# wait for the bookmark procedure to complete execution
	#
	while {$commentflag == 1} {
	    continue
	}
	
	# reset the background flag
	#
	set bgflag 0
    }
}
   
# procedure: load_prompt_proc
#
# arguments: none
#
# return: none
#
# procedure to prompt the user to load data
#
proc load_prompt_proc {} {

    # declare globals
    #
    global p

    global bg_col
    global transcriber_title

    global lock

    global loadflag
    global l

    # check if this needs to be done
    #
    if {($lock == 0) && ($loadflag == 1)} {
	
	# set the prompt window
	#
	set l ".load"
	toplevel $l
	wm title $l "transcriber_title Load"
	wm geometry $l "+300+200"
	wm focusmodel $l active

	# make a bottom frame
	#
	frame $l.foot -background $bg_col
	pack $l.foot -side bottom -fill x -pady 2m

	# add the save/dismiss buttons
	#	
	button $l.save -width 6 -default active -text Save \
		-background $bg_col -command {

	    # destroy the window
	    #
	    destroy $l

	    # save the changes made to the transcriptions
	    #
	    set status [save_proc]

	    # exit if an error occured while saving the transcriptions
	    #
	    if {$status == 1} { return 1 }

	    # load the new transcriptions
	    #
	    set status [load_cfgfile_proc]

	    # exit if an error occured while loading new transcriptions
	    #
	    if {$status == 1} { return 1 }
	}
	button $l.dismiss -width 6 -text Dismiss -background $bg_col \
		-command {

	    # destroy the window
	    #
	    destroy $l

	    # load the new transcriptions
	    #
	    set status [load_cfgfile_proc]

	    # exit if an error occured while loading new transcriptions
	    #
	    if {$status == 1} { return 1 }
	}

	pack $l.save -side left  -fill x -padx 1m -pady 1m -in $l.foot
	pack $l.dismiss -side right  -fill x -padx 1m -pady 1m -in $l.foot
	
	# make a message frame
	#
	frame $l.top -background $bg_col
	pack $l.top -side top -fill x -padx 1m -pady 1m
	
	message $l.msg -justify center -width 2i -background $bg_col -text \
		"Loading a new file will destroy unsaved work. \
		Do you want to save the current data?"
	pack $l.msg -side top -fill both -in $l.top
	
	# bind the return key
	#
	bind $l <Return> {

	    # destroy the window
	    #
	    destroy $

	    # save the changes made to the transcriptions
	    #
	    set status [save_proc]

	    # exit if an error occured while saving the transcriptions
	    #
	    if {$status == 1} { return 1 }

	    # load the new transcriptions
	    #
	    set status [load_cfgfile_proc]

	    # exit if an error occured while loading new transcriptions
	    #
	    if {$status == 1} { return 1 }
	}
    } else {

	# load the new transcriptions
	#
	set status [load_cfgfile_proc]
	
	# exit if an error occured while loading new transcriptions
	#
	if {$status == 1} { return 1 }
    }
}

# procedure: load_cfgfile_proc
#
# arguments: none
#
# return: none
#
# procedure to prompt the user to load data
#
proc load_cfgfile_proc {} {

    # declare globals
    #
    global config_file
    global cfgfile

    global default_data_dir

    global transcriber_title
    global num_utter
    global bg_col

    global w
    set w ".cfgfile"

    global audiolist

    global f

    # destroy the call selection window if it exist
    #
    catch {

	if {[winfo exists $f] == 1} {
	    destroy $f
	}
    }

    # don't recreate the window, try to reuse existing one
    #
    if {[winfo exists $w] == 1 } {
        wm deiconify $w
        raise $w
	
    } else {
	
	# set the default values
	#
	set cfgfile $config_file
	
	# create a new window
	#
	toplevel $w
        wm title $w "$transcriber_title Load Params"
        wm geometry $w "+200+200"
	wm focusmodel $w active

	# make a top and bottom frame
	#
	frame $w.top_f -background $bg_col
	frame $w.bot_f -background $bg_col
	pack $w.top_f -side top -fill both -expand true -padx 1 -pady 1
	pack $w.bot_f -side bottom -fill x -expand true -padx 1 -pady 1
	
	# create buttons to accept / cancel
        #
        button $w.ok -text OK -default active -width 12 -background $bg_col \
		-command {

	    # set the load flag if required
	    #
	    set loadflag 1

	    # set the new config file and close this window
	    #
	    if {$cfgfile != ""} {
		set config_file [expand_env_proc $cfgfile]
	    }
	    destroy $w

	    # check if the config file exists
	    #
	    if {[file exists $config_file] == 0} {
		warning_proc "The configuration file you have selected does \
			not exist please enter another file"

		# reset the load flag and exit
		#
		set loadflag 0

		return 1
	    }
	    
	    # set the filesel_flag to indicate that a config file has 
	    # been loaded
	    #
	    set filesel_flag 1

	    # load the parameters from the configuration file
	    #
	    set status [load_globals_proc]

	    # exit if there was an error in reading the configuration file
	    #
	    if {$status == 1} {	return 1 }

	    # load the list of calls from the call file list
	    #
	    set status [load_lists_proc]

	    # exit if there was an error in reading the call file list
	    #
	    if {$status == 1} {	return 1 }

	    # set the current focus
	    #
	    set status [current_list_proc 0]

	    # exit if there is an error in setting up the current call file
	    #
	    if {$status == 1} {	return 1 }

	    # read data from the file and set up the utterance list
	    #
	    set status [load_proc]

	    # exit if there is an error in load the transcriptions
	    #
	    if {$status == 1} {	return 1 }
	}
	
	# add the cancel button
	#
	button $w.cancel -text Cancel -command "destroy $w" -width 12 \
		-background $bg_col

	pack $w.ok $w.cancel -side left -in $w.bot_f -fill y -padx 1 -pady 1 \
		-expand true
	
	bind $w <Return> {
 
	    # check if the config file exists
	    #
	    if {[file exists $config_file] == 0} {
		warning_proc "The configuration file you have selected does \
			not exist please enter another file"
		return
	    }

	    # set the load flag if required
	    #
	    set loadflag 1

	    # set the new config file and close this window
	    #
	    if {$cfgfile != ""} {
		set config_file [expand_env_proc $cfgfile]
	    }
	    destroy $w
	    
	    # set the filesel_flag to indicate that a config file has 
	    # been loaded
	    #
	    set filesel_flag 1

	    # load the parameters from the configuration file
	    #
	    set status [load_globals_proc]

	    # exit if there was an error in reading the configuration file
	    #
	    if {$status == 1} {	return 1 }

	    # load the list of calls from the call file list
	    #
	    set status [load_lists_proc]

	    # exit if there was an error in reading the call file list
	    #
	    if {$status == 1} {	return 1 }

	    # set the current focus
	    #
	    set status [current_list_proc 0]

	    # exit if there is an error in setting up the current call file
	    #
	    if {$status == 1} {	return 1 }

	    # read data from the file and set up the utterance list
	    #
	    set status [load_proc]

	    # exit if there is an error in load the transcriptions
	    #
	    if {$status == 1} {	return 1 }
	}
	
	# setup the configuration file labels and entry fields
        #
        label $w.cfgfile_label -text "Config file:" -anchor w -width 15 \
		-background $bg_col
        entry $w.cfgfile_entry -textvariable cfgfile -width 60 \
		-background $bg_col

	# setup the configuration browse button
        #
        button $w.cfgbrowse -text Browse -background $bg_col -command {
	    set fmask "*"
	    if {[string trim $config_file] != ""} {
		append fmask [file extension $config_file]
	    } else {
		append fmask ".cfg"
	    }
            set cfgfile [tk_filesel .filesel -filemask $fmask \
                    -directory $default_data_dir]
        }

        pack $w.cfgfile_label $w.cfgfile_entry $w.cfgbrowse -side left \
                -fill both -expand true -padx 1 -pady 1 -in $w.top_f
    }

    # exit gracufully
    #
    return 0
}

# procedure: config_proc
#
# arguments: none
#
# return: none
#
# this procedure sets up the config pop-up window and processes the
# corresponding inputs
#
proc config_proc {} {

    # set globals
    #
    global audio_file

    global trans0_file

    global audio_server
    global audio_play_device

    global autosave_time
    global pause_time
    global transcriber_id

    global num_channels

    global config_flag
    global config_file

    # set local variables
    #
    global transfile
    global callfile

    global lexfile
    global lexicon_file
    global logfile

    global auserver
    global audevice

    global autosave
    global pause
    global transid

    global window_len
    global frame_len
    global preemph_coeff
    global preemph_flag
    global window_option
    global preemphasis_display
    global window_size
    global rms_scale

    global reload_flag

    global cfg
    set cfg ".config"

    global transcriber_title

    global bg_col
    global default_data_dir

    # set the config flag to indicate that the procedure has been visited
    #
    set config_flag 1

    # don't recreate the window, try to reuse existing one
    #
    if { [winfo exists $cfg] == 1 } {
        wm deiconify $cfg
        raise $cfg
 
    } else {
 
	# set the default values
	#
	set auserver $audio_server
	set audevice $audio_play_device
	set autosave $autosave_time
	set pause $pause_time
	set transid $transcriber_id

        # create a new window
        #
        toplevel $cfg
        wm title $cfg "$transcriber_title Configuration"
	wm geometry $cfg "+200+200"
	wm focusmodel $cfg active

	# make a top and bottom frame
	#
	frame $cfg.top1_f -borderwidth 0 -background $bg_col
	frame $cfg.top2_f -borderwidth 0 -background $bg_col
	frame $cfg.top3_f -borderwidth 0 -background $bg_col
	frame $cfg.top4_f -borderwidth 0 -background $bg_col
	frame $cfg.top5_f -borderwidth 0 -background $bg_col
	frame $cfg.foot -borderwidth 1 -background $bg_col
	
	# pack the top and bottom frame
	#
	pack $cfg.top1_f $cfg.top2_f $cfg.top3_f $cfg.top4_f $cfg.top5_f \
		-side top -fill both -expand true 
	pack $cfg.foot -side bottom -fill both -expand true -pady 2
	
	# create buttons to accept / cancel
	#
        button $cfg.ok -text Ok -width 12 -default active \
		-background $bg_col -command {
	    # reset the config flag to indicate that we have left 
            # the config procedure
	    #
	    set config_flag 0
	    config_ok_proc
	}
	button $cfg.cancel -text Cancel -width 12 -background $bg_col \
		-command {
	    # reset the config flag to indicate that we have left 
            # the config procedure
	    #
	    set config_flag 0
	    destroy $cfg
	}

        pack $cfg.ok -side left -in $cfg.foot -fill x -padx 1 -pady 1
        pack $cfg.cancel -side right -in $cfg.foot -fill x -padx 1 -pady 1

	bind $cfg <Return> {
	    # reset the config flag to indicate that we have left 
            # the config procedure
	    #
	    set config_flag 0
	    config_ok_proc
	}
	
	# make frames for session file entry
	#
	frame $cfg.session_f -background $bg_col
	frame $cfg.sessfile_f -background $bg_col
	frame $cfg.log_f -background $bg_col
	frame $cfg.trans_f -background $bg_col
	frame $cfg.lexfile_f -background $bg_col
	frame $cfg.transid_f -background $bg_col

	# make frames for audio related parameters entry
	#
	frame $cfg.audio_f -background $bg_col
	frame $cfg.audevice_f -background $bg_col
	frame $cfg.auserver_f -background $bg_col
	frame $cfg.aufile_f -background $bg_col

	# make frames for energy plot parameters entry
	#
	frame $cfg.energy_f -background $bg_col
	frame $cfg.frmlen_f -background $bg_col
	frame $cfg.winlen_f -background $bg_col
	frame $cfg.rms_f -background $bg_col
	frame $cfg.size_f -background $bg_col

	# make frames for energy plot parameters entry
	#
	frame $cfg.spec_f -background $bg_col
	frame $cfg.contrast_f -background $bg_col
	frame $cfg.brightness_f -background $bg_col
	
	# make frames for common attributes
	#
	frame $cfg.misc_f -background $bg_col
	frame $cfg.preemp_f -background $bg_col
	frame $cfg.preflg_f -background $bg_col
	frame $cfg.hamflg_f -background $bg_col

	pack $cfg.session_f $cfg.sessfile_f $cfg.log_f $cfg.trans_f \
		$cfg.lexfile_f $cfg.transid_f -in $cfg.top1_f -side top \
		-padx 1 -pady 1 -fill both -expand true

	pack $cfg.audio_f $cfg.aufile_f $cfg.audevice_f $cfg.auserver_f \
		-side top -fill both -padx 1 -pady 1  -expand true \
		-in $cfg.top2_f

	pack $cfg.energy_f $cfg.frmlen_f $cfg.winlen_f $cfg.rms_f $cfg.size_f \
		-padx 1 -pady 1 -fill both -expand true -in $cfg.top3_f

	pack $cfg.spec_f $cfg.contrast_f $cfg.brightness_f \
		-padx 1 -pady 1 -fill both -expand true -in $cfg.top4_f

	pack $cfg.misc_f $cfg.preemp_f $cfg.preflg_f $cfg.hamflg_f \
		-padx 1 -pady 1 -fill both -expand true -in $cfg.top5_f


	# pack the lables header and fields for the session file
	#
	label $cfg.session_label -text "Session File" -background $bg_col
	pack $cfg.session_label -fill both -anchor w -in $cfg.session_f

	# setup the session file name and browsing facilities
	#
	label $cfg.sessfile_label -text "Session:" -anchor w \
		-width 20  -background $bg_col
	entry $cfg.sessfile_entry -textvariable config_file -width 60 \
		-background $bg_col
	button $cfg.ibrowse -text Browse -background $bg_col -command {
	    set fmask "*"
	    set reload_flag 1
	    append fmask [file extension $config_file]
	    set config_file [tk_filesel .filesel -filemask $fmask \
		    -directory $default_data_dir]
	}
	pack $cfg.sessfile_label $cfg.sessfile_entry $cfg.ibrowse \
		-side left -fill both -expand true -padx 1 -pady 1 \
		-in $cfg.sessfile_f

	# setup the logfile
	#
	label $cfg.log_label -text "Comment File:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.log_entry -textvariable logfile -width 60 \
		-state disabled -background $bg_col
	label $cfg.foo1 -text "" -width 10 -background $bg_col
	pack $cfg.log_label $cfg.log_entry $cfg.foo1 -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.log_f

	# setup the transfile
	#
	label $cfg.trans_label -text "Trans File:" -anchor w \
		-width 20 -background $bg_col
	entry $cfg.trans_entry -textvariable transfile -width 60 \
		-state disabled -background $bg_col
	label $cfg.foo2 -text "" -width 10 -background $bg_col
	pack $cfg.trans_label $cfg.trans_entry $cfg.foo2 -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.trans_f

	# setup the lexicon file
	#
	label $cfg.lexfile_label -text "Lexicon file:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.lexfile_entry -textvariable lexicon_file -width 60 \
		-state disabled -background $bg_col
	label $cfg.foo3 -text "" -width 10 -background $bg_col
	pack $cfg.lexfile_label $cfg.lexfile_entry $cfg.foo3 -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.lexfile_f

	# setup the transcriber id
	#
	label $cfg.transid_label -text "Transcriber id:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.transid_entry -textvariable transid -width 60 \
		-background $bg_col
	label $cfg.foo4 -text "" -width 10 -background $bg_col
	pack $cfg.transid_label $cfg.transid_entry $cfg.foo4 -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.transid_f

	# pack the lables header for the audio related parameters
	#
	label $cfg.audio_label -text "Audio-related Parameters"  \
		-background $bg_col
	pack $cfg.audio_label -fill both -anchor w -in $cfg.audio_f
    	
	# set up the audio play device
	#
	label $cfg.audevice_label -text "Audio device:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.audevice_entry -textvariable audevice -width 60 \
		-background $bg_col
	button $cfg.audevsel -text Toggle -background $bg_col -command {
	    if {$audevice == "sparc"} {
		set audevice "dat"
		set auserver ""
	    } elseif {$audevice == "dat"} {
		set audevice "ncd"
		set auserver "$env(DISPLAY)"
	    } elseif {$audevice == "ncd"} {
		set audevice "x86"
		set auserver "speaker"
	    } elseif {$audevice == "x86"} {
		set audevice ""
		set auserver ""
	    } elseif {$audevice == ""} {
		set audevice "sparc"
		set auserver "speaker"
	    }
	}
	pack $cfg.audevice_label $cfg.audevice_entry $cfg.audevsel -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.audevice_f
	
	# setup the audio server
	#
	label $cfg.auserver_label -text "Audio server:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.auserver_entry -textvariable auserver -width 60 \
		-background $bg_col
	button $cfg.auservsel -text Toggle -background $bg_col -command {
	    if {$audevice == "sparc"} {
		if {$auserver == "speaker"} {
		    set auserver "headphone"
		} elseif {$auserver == "headphone"} {
		    set auserver "line"
		} elseif {$auserver == "line"} {
		    set auserver ""
		} else {
		    set auserver "speaker"
		}
	    } elseif {$audevice == "dat"} {
		if {$auserver != ""} {
		    set auserver ""
		}
	    } elseif {$audevice == "ncd"} {
		if {$auserver == ""} {
		    set auserver "$env(DISPLAY)"
		} else {
		    set auserver ""
		}
	    } elseif {$audevice == "x86"} {
		if {$auserver == "speaker"} {
		    set auserver "headphone"
		} elseif {$auserver == "headphone"} {
		    set auserver "line"
		} elseif {$auserver == "line"} {
		    set auserver ""
		} else {
		    set auserver "speaker"
		}
	    } elseif {$audevice == ""} {
		set auserver ""
	    }
	}
	pack $cfg.auserver_label $cfg.auserver_entry $cfg.auservsel \
		-side left -fill both -expand true -padx 1 -pady 1 \
		-in $cfg.auserver_f
	
	# pack the lables header for the energy plot widget
	#
	label $cfg.energy_label -text "Energy Plot Parameters" \
		-background $bg_col
	pack $cfg.energy_label -fill both -anchor w -in $cfg.energy_f

	# setup the frame length
	#
	label $cfg.frmlen_label -text "Frame Length:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.frmlen_entry -textvariable frame_len -width 60 \
		-background $bg_col
	label $cfg.foo5 -text "" -width 10 -anchor w -background $bg_col
	pack $cfg.frmlen_label $cfg.frmlen_entry $cfg.foo5 -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.frmlen_f

	# setup the window length
	#
	label $cfg.winlen_label -text "Window Length:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.winlen_entry -textvariable window_len -width 60 \
		-background $bg_col
	label $cfg.foo6 -text "" -width 10 -anchor w -background $bg_col
	pack $cfg.winlen_label $cfg.winlen_entry $cfg.foo6 -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.winlen_f

	# setup the rms scaling factor
	#
	label $cfg.rms_label -text "Rms Scale:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.rms_entry -textvariable rms_factor -width 60 \
		-background $bg_col
	label $cfg.foo8 -text "" -width 10 -anchor w -background $bg_col
	pack $cfg.rms_label $cfg.rms_entry $cfg.foo8 -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.rms_f
	
	# set up the energy plot configuration option
	#
	label $cfg.size_label -text "Canvas Size:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.size_entry -textvariable window_size -width 60 \
		-background $bg_col
	label $cfg.foo10 -text "Percent(%)" -width 10 -anchor w \
		-background $bg_col
	pack $cfg.size_label $cfg.size_entry $cfg.foo10 -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.size_f

	# set up the configuration options for the spectrogram
	#
	label $cfg.spec_label -text "Spectrogram Parameters" \
		-background $bg_col
	pack $cfg.spec_label -fill both -anchor w -in $cfg.spec_f

	# setup the contrast length
	#
	label $cfg.contrast_label -text "Contrast:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.contrast_entry -textvariable contrast_d -width 60 \
		-background $bg_col
	label $cfg.foo11 -text "" -width 10 -anchor w -background $bg_col
	pack $cfg.contrast_label $cfg.contrast_entry $cfg.foo11 -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.contrast_f

	# setup the brightness length
	#
	label $cfg.brightness_label -text "Brightness:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.brightness_entry -textvariable brightness_d -width 60 \
		-background $bg_col
	label $cfg.foo12 -text "" -width 10 -anchor w -background $bg_col
	pack $cfg.brightness_label $cfg.brightness_entry $cfg.foo12 \
		-side left -fill both -expand true -padx 1 -pady 1 \
		-in $cfg.brightness_f

	# set up the miscellaneous configuration options
	#
	label $cfg.misc_label -text "Miscellaneous" \
		-background $bg_col
	pack $cfg.misc_label -fill both -anchor w -in $cfg.misc_f

	# set up the wind function option
	#
	label $cfg.hamflg_label -text "Window Function:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.hamflg_entry -textvariable window_option -width 60 \
		-background $bg_col
	button $cfg.hamsel -text Toggle -background $bg_col -command {
	    if {$window_option == "bartlett"} {
		set window_option "blackman"
	    } elseif {$window_option == "blackman"} {
		set window_option "hamming"
	    } elseif {$window_option == "hamming"} {
		set window_option "hanning"
	    } elseif {$window_option == "hanning"} {
		set window_option "rectangular"
	    } elseif {$window_option == "rectangular"} {
		set window_option "bartlett"
	    }
	}
	pack $cfg.hamflg_label $cfg.hamflg_entry $cfg.hamsel -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.hamflg_f

	# set up the preemphasis flag
	#
	label $cfg.preflg_label -text "Preemphasis:" -anchor w -width 20 \
		-background $bg_col
	entry $cfg.preflg_entry -textvariable preemphasis_display -width 60 \
		-background $bg_col

	button $cfg.presel -text Toggle -background $bg_col -command {
	    if {$preemph_flag == 1} {
		set preemph_flag 0
		set preemphasis_display "Off"
	    } elseif {$preemph_flag == 0} {
		set preemph_flag 1
		set preemphasis_display "On"
	    }
	}
	pack $cfg.preflg_label $cfg.preflg_entry $cfg.presel -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.preflg_f

	# setup the preemphasis coefficient
	#
	label $cfg.preemp_label -text "Preemphasis Coeff:" -anchor w \
		-width 20 -background $bg_col
	entry $cfg.preemp_entry -textvariable preemph_coeff -width 60 \
		-background $bg_col
	label $cfg.foo7 -text "" -width 10 -anchor w -background $bg_col
	pack $cfg.preemp_label $cfg.preemp_entry $cfg.foo7 -side left \
		-fill both -expand true -padx 1 -pady 1 -in $cfg.preemp_f

    }
}

# procedure: config_ok_proc 
#
# arguments: none
#
# return: none
#
# procedure to set entered variables
#
proc config_ok_proc {} {

    # declare globals
    #
    global cfg p

    global reload_flag
    global config_file

    global frame_len
    global window_size
    global signal_ht
    global energy_ht

    # get the height of the frame
    #
    set frame_ht [$p.plot_f cget -height]
	
    # set the new height of the energy canvas
    #
    set energy_ht [expr int((($window_size / 100.00) * $frame_ht))]
	
    # set the new height of the signal frame
    #
    set signal_ht [expr $frame_ht - $energy_ht]
	
    # configure the canvas heights
    #
    $p.energy0_plot configure -height $energy_ht
    $p.chan0_plot configure -height $signal_ht
    
    # error check for the energy plot frame length 
    #
    if {$frame_len <= 0} {
	set frame_len 0.01
    }

    # error check for the window size
    #
    if {$window_size < 0 || $window_size > 100} {
	set window_size 25
    }

    # load the corresponding data if necessary
    #
    if {$reload_flag == 1} {
	
	# check if data needs to be saved before reload
	#
	config_reload_proc
	set reload_flag 0
	update_window

    } else {

	# set variables to new values and quit
	#
	config_set_proc
	destroy $cfg
	update_window
    }
}

# procedure: config_reload_proc 
#
# arguments: none
#
# return: none
#
# procedure to confirm reloading of data
#
proc config_reload_proc {} {

    # create globals
    #
    global cfg

    global transcriber_title
    global bg_col

    global trans_list
    global word_list
    global log_list

    global loadflag

    global arraylist
    global keycount
    global keys

    global last_utter
    global last_call

    global callfile_list

    global w_save
    set w_save ".cfg_save"

    global lock loadflag

    # check if this needs to be done
    #
    if {($lock == 1) || ($loadflag == 0)} {
	destroy $cfg
	load_cfgfile_proc
	return
    }

    # create a dialog window
    #
    toplevel $w_save
    wm title $w_save "$transcriber_title Reload"
    wm geometry $w_save "+300+400"
    wm focusmodel $w_save active

    # make a bottom frame
    #
    frame $w_save.foot -background $bg_col
    pack $w_save.foot -side bottom -fill x -pady 2m
    
    button $w_save.save -width 6 -default active -text Yes \
	    -background $bg_col -command {
	
	# set the current fileds
	#
	destroy $w_save
	config_set_proc
	destroy $cfg

	save_proc
	
	# read data from the file and set up the utterance list
	#
	load_cfgfile_proc
    }

    button $w_save.ok -width 6 -text No  -background $bg_col -command {

	# set the current fileds
	#
	destroy $w_save
	config_set_proc
	destroy $cfg

	# read data from the file and set up the utterance list
	#
	load_cfgfile_proc
    }
    button $w_save.cancel -width 6 -text Cancel -background $bg_col -command {
	destroy $w_save
    }
    pack $w_save.save $w_save.ok $w_save.cancel -side left  -fill x \
	    -padx 1m -pady 1m -expand true -in $w_save.foot
    
    # make a message frame
    #
    frame $w_save.top -background $bg_col
    pack $w_save.top -side top -fill x -padx 1m -pady 1m
    
    message $w_save.msg -justify center -width 2i -background $bg_col -text \
	    "This will reload data from file and destroy unsaved work. \
	    Do you want to save data before you reload?"
    pack $w_save.msg -side top -fill both -in $w_save.top

    # bind the return key
    #
    bind $w_save <Return> {
	
	# set the current fileds
	#
	destroy $w_save
	config_set_proc
	destroy $cfg
	
	save_proc

	# read data from the file and set up the utterance list
	#
	load_cfgfile_proc
    }
}

# procedure: config_set_proc
#
# arguments: none
#
# return: none
#
# procedure to set filenames
#
proc config_set_proc {} {

    # declare globals
    #
    global audio_server
    global audio_play_device

    global autosave_time
    global pause_time
    global transcriber_id
    
    global num_channels
    
    # set local variables
    #
    global auserver
    global audevice

    global autosave
    global pause
    global transid
    
    global lock loadflag
	
    # check if this needs to be done
    #
    if {($lock == 0) && ($loadflag == 1)} {
    
	if {$auserver != ""} {
	    set audio_server [expand_env_proc $auserver]
	}
	if {$audevice != ""} {
	    set audio_play_device [expand_env_proc $audevice]
	}
	if {$autosave != ""} {
	    set autosave_time [expand_env_proc $autosave]
	}
	if {$pause != ""} {
	    set pause_time [expand_env_proc $pause]
	}
	if {$transid != ""} {
	    set transcriber_id [expand_env_proc $transid]
	}
    }
}

#
# end of file
