#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/channel.tcl
#
# procedure to manipulate channel
#

# list of procedures:
#
#  set_channel_proc {chan_in}
#

# procedure: set_channel_proc
#
# arguments:
#  chan_in: input channel
#
# return: none
#
# this procedure to sets the current channel
#
proc set_channel_proc {chan_in} {

    # declare globals
    #
    global p

    global play_mode
    global current_time

    # set the current channel 
    #
    set current_channel $chan_in

    # set play mode
    #
    set play_mode 0

    # update the listbox
    #
    reorder_proc
    fill_list_proc

    # set the current utterance focus
    #
    set_current_proc 0

    # update the plot relief
    #
    $p.chan0_plot configure -relief flat
    $p.energy0_plot configure -relief flat
    $p.spec0_plot configure -relief flat
}

#
# end of file
