#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/brackets.tcl
#
# procedures to manipulate time-markers or brackets
#

# list of procedures:
#
#  bracket_marks_proc {}
#  bracket_draw_proc {x_in y_in}
#  bracket_plot_proc {start_in end_in}
#

# procedure: bracket_marks_proc
#
# arguments: none
#
# return: none
#
# process to set the utterance limits to the bracket marks
#
proc bracket_marks_proc {} {
    
    # declare global variables
    #
    global bracket_start
    global bracket_end
    
    global cutt_start
    global cutt_end

    global maximum_time

    global current_channel
    global chan0_uttlist

    global p

    global lock
    global loadflag

    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }

    # do if the segments are unlocked
    #
    if {$lock == 0} {

	# set the current utterance duration to area specified by brackets
	#
	if {$cutt_start != 0} {
	    set cutt_start [format "%.6f" $bracket_start]
	}
	if {$cutt_end != $maximum_time} {
	    set cutt_end [format "%.6f" $bracket_end]
	}
	
	# save this data in the utterance node
	#
	set_utt_proc
	
	# update display
	#
	bracket_plot_proc $cutt_start $cutt_end
    }

    # update display
    #
    display_time_proc
}

# procedure: bracket_marks_proc
#
# arguments:
#  x_in: x coordinate
#  y_in: y coordinate
#
# return: none
#
# procedure to draw and drag time markers
#
proc bracket_draw_proc {x_in y_in} {

    # declare global variables
    #
    global current_time

    global window_start
    global window_end
    global window_duration

    global plot_width

    global bracket_signal_end_line
    global bracket_energy_end_line
    global bracket_spec_end_line

    global p

    # make sure that the x and y are on the canvas...
    #
    if {$x_in > $plot_width} {
        set x $plot_width
    } elseif {$x_in >= 0} {
        set x $x_in
    } else {
        set x 0
    }
    
    # set the current time based on the position on the screen
    #
    set current_time [eval expr ($window_duration / $plot_width) \
	    * $x + $window_start]
    
    # draw a line at the end time
    #
    $p.chan0_plot coords $bracket_signal_end_line $x 0 $x \
	    [winfo height $p.chan0_plot]
    $p.energy0_plot coords $bracket_energy_end_line $x 0 $x \
	    [winfo height $p.energy0_plot]
    $p.spec0_plot coords $bracket_spec_end_line $x 0 $x \
	    [winfo height $p.spec0_plot]

    # update display
    #
    display_time_proc
}

# procedure: bracket_marks_proc
#
# arguments:
#  start_in: utterance start time
#  end_in: utterance end time
#
# return: none
#
# procedure to plot brackets at given times
#
proc bracket_plot_proc {start_in end_in} {

    # set global variables
    #
    global window_start
    global window_end
    global window_duration

    global bracket_start
    global bracket_end
    global bracket_duration

    global plot_width
    global energy_ht
    global signal_ht

    global bracket_signal_start_line
    global bracket_signal_end_line

    global bracket_energy_start_line
    global bracket_energy_end_line

    global bracket_spec_start_line
    global bracket_spec_end_line
 
    global p

    # make sure that the start and end are within range
    #
    if {($start_in < $window_start) || ($start_in > $window_end)} { 
        set $bracket_start $window_start
    } else {
	set bracket_start $start_in
    }
    if {($end_in < $window_start) || ($end_in > $window_end)} {
	set $bracket_end $window_end
    } else {
        set bracket_end $end_in
    }

    if {$bracket_start > $bracket_end} {
	set tmp $bracket_end
	set bracket_end $bracket_start
	set bracket_start $tmp
    }

    set bracket_duration [eval expr $bracket_end - $bracket_start]

    # set the screen coordinates
    #
    set x1 [eval expr ($plot_width / $window_duration) \
	    * ($bracket_start - $window_start)]
    set x2 [eval expr ($plot_width / $window_duration) \
	    * ($bracket_end - $window_start)]
    
    # draw a bracket line at the start time
    #
    $p.chan0_plot coords $bracket_signal_start_line $x1 0 $x1 \
	    [winfo height $p.chan0_plot]
    $p.energy0_plot coords $bracket_energy_start_line $x1 0 $x1 \
	    [winfo height $p.energy0_plot]
    $p.spec0_plot coords $bracket_spec_start_line $x1 0 $x1 \
	    [winfo height $p.spec0_plot]

    # draw a bracket line at the end time
    #
    $p.chan0_plot coords $bracket_signal_end_line $x2 0 $x2 \
	    [winfo height $p.chan0_plot]
    $p.energy0_plot coords $bracket_energy_end_line $x2 0 $x2 \
	    [winfo height $p.energy0_plot]
    $p.spec0_plot coords $bracket_spec_end_line $x2 0 $x2 \
	    [winfo height $p.spec0_plot]

    # update display
    #
    display_time_proc
}

#
# end of file





