#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/bookmark.tcl
#
# procedures to set and make bookmark entries in the log file
#

# list of procedures:
#
#  bookmark_proc {}
#  bookmark_entry_proc {}
#

# procedure: bookmark_proc
#
# arguments: none
#
# return: none
#
# procedure to set a bookmark in the log file
#
proc bookmark_proc {} {

    # define globals
    #
    global bm
    set bm ".book"

    global transcriber_title
    global bg_col

    global bm_start
    
    global lock

    # no bookmarks are needed if a lock is set
    #
    if {$lock == 1} {
	return
    }

    # create a new window
    #
    toplevel $bm
    wm title $bm "$transcriber_title Bookmark"
    wm geometry $bm "+300+200"
    wm minsize $bm 250 150
    wm focusmodel $bm active

    # set the message string
    #
    set mesg_str "--- Please set a bookmark ---\n\n \
	    Set the utterance you want to bookmark as current, \
	    and then press \"Bookmark\" to mark it as the starting \
	    or stopping point.\n\n To view your previous bookmarks, \
	    see the log file or press \"View\"."
    
    # make top and bottom frames
    #
    frame $bm.top_f -borderwidth 1 -background $bg_col -height 200
    frame $bm.bot_f -borderwidth 1 -background $bg_col -height 40
    pack $bm.top_f -side top -fill both -padx 1 -pady 1 -expand true
    pack $bm.bot_f -side bottom -fill both -padx 1 -pady 1
    
    # show message
    #
    message $bm.mesg -justify center -width 2.5i -text $mesg_str \
	    -background $bg_col
    pack $bm.mesg -fill both -expand true -padx 1 -pady 1 -in $bm.top_f
    
    # set the set and view buttons
    #
    button $bm.set -text "Bookmark" -width 10 -background $bg_col \
	    -command {
	bookmark_entry_proc
	set bm_start 1
	destroy $bm
    }
    
    button $bm.view -text View -width 10 -background $bg_col -command {
	log_view_proc
    }
    
    button $bm.quit -text Dismiss -width 10 -background $bg_col \
	    -command {
	set bm_start 1
	destroy $bm
    }
    
    pack $bm.set $bm.view -side left -padx 1 -pady 1 -in $bm.bot_f
    pack $bm.quit -side right -padx 1 -pady 1 -in $bm.bot_f
}

# procedure: bookmark_entry_proc 
#
# arguments: none
#
# return: none
#
# procedure to make a bookmark entry
#
proc bookmark_entry_proc {} {
    
    # define globals
    #
    global logfile
    global transcriber_id
    global cutt_id
    global audiolist
    global audio_file
    global logfile
    
    global bookmark_flag
    global commentflag

    # create the log file if it does not exist, otherwise open in
    # append mode
    #
    set fileptr ""

    if {[file exists $logfile] != 1} {
	set fileptr [open $logfile w]

    } else {
	set fileptr [open $logfile a]

    }

    # make sure the log file is writable
    #
    if {[file writable $logfile] != 1} {
	warning_proc "Cannot write to the log file $logfile. Please \
		make sure the file has write permissions."

	return 1
    }

    # set the comment flag
    #
    set commentflag 1

    # read and parse the comment file
    #
    read_comment_proc

    # retrieve the current audiofile
    #
    set file ""
    set file $audio_file

    # check if this is to be a start or stop bookmark
    #
    if {$bookmark_flag == 0} {
	
	# reset the bookmark flag to start
	#
	set bookmark_flag 1
	
	# write the info to the log file
	#
	puts $fileptr "\n"
	puts $fileptr "<--- Bookmark: START -- [clock format \
		[clock seconds]] ---------->"
	puts $fileptr "Transcriber: $transcriber_id"
	puts $fileptr "Utterance: $file\n"
    } else {
	
	# clear the bookmark flag to stop
	#
	set bookmark_flag 0
	
	# write the info to the log file
	#
	puts $fileptr "Transcriber: $transcriber_id"
	puts $fileptr "Utterance: $file"
	puts $fileptr "<--- Bookmark: STOP  -- [clock format \
		[clock seconds]] ---------->\n\n"
    }
    
    # close the file
    #
    close $fileptr

    # reset the comment flag
    #
    set commentflag 0

    # exit gracefully
    #
    return 0
}

#
# end of file
