#! /usr/local/bin/wish -f

# file: $ISIP_TRANSCRIBER/gui/src/bindings.tcl
#
# definitions of principal key bindings and on-line functional help 
# for the transcriber
#

# declare globals
#
global p wrn

global play_mode
global current_channel
global loadflag

global arraylist
global audiolist
global curr_ind

global state

global signal_ht
global energy_ht
global window_size

bind $p.curr_trans <Return> {
    
    if {[string match $state $p.noise] == 1} {
	set state $p.mean
	$p.noise popup
	$p.type popdown
    } elseif {[string match $state  $p.mean] == 1} {
	set state $p.age
	$p.mean popup
	$p.noise popdown
    } elseif {[string match $state  $p.age] == 1} {
	set state $p.gender
	$p.age popup
	$p.mean popdown
    } elseif {[string match $state  $p.gender] == 1} {
	set state $p.type
	$p.gender popup
	$p.age popdown
    } elseif {[string match $state  $p.type] == 1} {
	set state ""
	$p.type popup
	$p.gender popdown
    } else {
	if {[string match [focus -displayof $p] $p.curr_trans] == 1} {
	    set state $p.mean
	    $p.noise popup
	} else {
	    set state $p.noise
	    $p.type popdown
	    focus $p.curr_trans
	}
    }
}

# focus on the window upon entry with the mouse
#
bind $p.curr_trans <Enter> {
    focus %W
}

# turn off the insertion of new line commands in the transcrition area
#
bind Text <Return> {
    break
}

# allow for autofill capabilities in the transcription area
#
bind $p.curr_trans <Tab> {
    search_hash_proc
}

# turn off the insertion of tab characters in ANY text widget
#
bind Text <Tab> {
    focus %W
    break
}

# allow for automatic resizing of the plots
#
bind $p.chan0_plot <Configure> { update_window }
bind $p.energy0_plot <Configure> { update_window }
bind $p.spec0_plot <Configure> { update_window }

# bind the graphics menu to the right mouse button
#
bind $p <ButtonPress-3> {tk_popup $p.menu_graphics %X %Y}

# general key bindings for the tool
#
bind $p <Alt-Right> {
    $p config -cursor watch
    update
    window_ahead_proc
    $p config -cursor top_left_arrow
}

bind $p <Alt-Left> {
    $p config -cursor watch
    update
    window_back_proc
    $p config -cursor top_left_arrow
}

bind $p <Alt-Up> {
    $p config -cursor watch
    update
    zoom_out_proc
    $p config -cursor top_left_arrow
}

bind $p <Alt-Down> {
    $p config -cursor watch
    update
    zoom_in_proc
    $p config -cursor top_left_arrow
}

bind $p <Alt-c> {
    config_proc
    update
}

bind $p <Alt-h> {
    help_proc
}

bind $p <Alt-l> {
    $p config -cursor watch
    update
    load_cfgfile_proc
    $p config -cursor top_left_arrow
}

bind $p <Alt-m> {
    play_brackets_proc
}

bind $p <Alt-o> {
    bookmark_entry_proc
}

bind $p <Alt-q> {
    quit_proc
}

bind $p <Alt-b> {
    $p config -cursor watch
    zoom_brackets_proc
    $p config -cursor top_left_arrow
}

bind $p <Alt-u> {
    play_utt_proc 0
}

bind $p <Alt-v> {
    verify_proc
    update
}

bind $p <Alt-w> {
    play_window_proc
}

bind $p <Alt-x> {
    $p config -cursor watch
    update
    lexicon_proc
    $p config -cursor top_left_arrow
}

bind $p <Alt-z> {
    $p config -cursor watch
    update
    zoom_full_proc
    $p config -cursor top_left_arrow
}

# key-bindings for the pop down listbox parameters
#
bind $p <F1> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # play the previous utterance
    #
    $p config -cursor watch
    prev_utt_proc
    $p config -cursor top_left_arrow
}
bind $p <F2> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # play next utterance
    #
    $p config -cursor watch
    next_utt_proc
    $p config -cursor top_left_arrow
}
bind $p <F3> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # move to the previous call
    #
    prev_call_proc
}
bind $p <F4> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # move to the previous call
    #
    next_call_proc
}
bind $p <F5> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # play between brackets
    #
    play_brackets_proc
}
bind $p <F6> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # play current utterance
    #
    play_utt_proc 0
}
bind $p <F8> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # play the call
    #
    verify_proc
    set callflag 0
    update
}
bind $p <F9> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # start the lexicon
    #
    $p config -cursor watch
    update
    lexicon_proc
    $p config -cursor top_left_arrow
}
bind $p <F10> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # clear the current contents
    #
    clear_trans_proc
    
    # include the silence tag in the trancription box
    #
    $p.curr_trans insert end $silence_tag
}

bind $p.chan0_plot <space> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # play between brackets
    #
    play_brackets_proc
}

bind $p.energy0_plot <space> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # play between brackets
    #
    play_brackets_proc
}

bind $p.spec0_plot <space> {
    
    # return if nothing is loaded
    #
    if {$loadflag == 0} {
	return
    }
    
    # play between brackets
    #
    play_brackets_proc
}

# focus settings for the signal plot widget canvas
#
bind $p.chan0_plot <Enter> {
    focus %W
}
bind $p.chan0_plot <Leave> {
    focus $p.curr_trans
}

# focus settings for the energy plot widget canvas
#
bind $p.energy0_plot <Enter> {
    focus %W
}
bind $p.energy0_plot <Leave> {
    focus $p.curr_trans
}

# focus settings for the energy plot widget canvas
#
bind $p.spec0_plot <Enter> {
    focus %W
}
bind $p.spec0_plot <Leave> {
    focus $p.curr_trans
}

# mouse bindings for the signal plot area
#
bind $p.chan0_plot <ButtonPress-1> {
    get_start_coords %x %y
}
bind $p.chan0_plot <ButtonRelease-1> {
    get_end_coords %x %y
}

# mouse bindings for the energy plot area
#
bind $p.energy0_plot <ButtonPress-1> {
    get_start_coords %x %y
}
bind $p.energy0_plot <ButtonRelease-1> {
    get_end_coords %x %y
}

# mouse bindings for the spectrogram area
#
bind $p.spec0_plot <ButtonPress-1> {
    get_start_coords %x %y
}
bind $p.spec0_plot <ButtonRelease-1> {
    get_end_coords %x %y
}

# mouse motion for the signal plot
#
bind $p.chan0_plot <B1-Motion> {
    bracket_draw_proc %x %y
}
bind $p.chan0_plot <Motion> {
    get_time_proc %x %y
}

# mouse motion for the energy plot
#
bind $p.energy0_plot <B1-Motion> {
    bracket_draw_proc %x %y
}
bind $p.energy0_plot <Motion> {
    get_time_proc %x %y
}

# mouse motion for the energy plot
#
bind $p.spec0_plot <B1-Motion> {
    bracket_draw_proc %x %y
}
bind $p.spec0_plot <Motion> {
    get_time_proc %x %y
} 

#--------------------------------------------------------------------------
# bind the middle mouse to help for each button
#--------------------------------------------------------------------------

# main control buttons
#
set load_hlpstr "Load\n\nLoad the desired configuration file. The \
	configuration file contains the parameters required to load \
	the speech and transcription data."
bind $p.load <ButtonPress-2> {
    help_item_proc $load_hlpstr
}

set config_hlpstr "Config\n\nSet or change the desired configuration \
	options. These allow you to load specific audio and \
	transcription files, set the audio play environment and other \
	useful system parameters."
bind $p.config <ButtonPress-2> {
    help_item_proc $config_hlpstr
}

set log_hlpstr "Log\n\nEnter a log message corresponding to the \
	current utterance, or view the log file to see the log messages \
	entered so far. You can also set a start or stop bookmark \
	here. If you do not have a specific log message, Alt-r will \
	set a log with an automatic message \"Needs Review\"."
bind $p.log <ButtonPress-2> {
    help_item_proc $log_hlpstr
}

set save_hlpstr "Save\n\nSave the transcription (and word alignment, \
	if any) data to disk. The Transcriber over-writes the input \
	transcription (and word alignment) files."
bind $p.save <ButtonPress-2> {
    help_item_proc $save_hlpstr
}

set help_hlpstr "Help\n\nView the on-line documents containing a list \
	of available key-bindings, the recommended transcription \
	guidelines and some general instructions regarding how to \
	transcribe data using the Transcriber."
bind $p.help <ButtonPress-2> {
    help_item_proc $help_hlpstr
}

set quit_hlpstr "Quit\n\nClose the Transcriber and exit. The Transcriber will \
	prompt you to save data if necessary."
bind $p.quit <ButtonPress-2> {
    help_item_proc $quit_hlpstr
}

# lock modes
#
set lock_hlpstr "Lock\n\nThe Transcriber can be run in three different \
	modes to provide the user with greater ease of operation. The \
	\"Lock\" button will lock the segment boundaries and the \
	transcriptions so that they cannot be altered. The Transcriber \
	serves as an audio play-only tool in this case. You can also \
	set either lock individually by clicking on the corresponding \
	checkbutton.\n\nThe \"Segments\" lock will fix the time alignment \
	but allow you to change the transcriptions.\n\nThe \
	\"Transcriptions\" lock will fix the transcriptions but allow \
	you to alter the time boundary marks.\n\nWhen both locks are \
	disabled, you can change both the transcription and the alignment."
bind $p.lock <ButtonPress-2> {
    help_item_proc $lock_hlpstr
}

# volume and amplitude gain
#
set volume_label_hlpstr "Volume Match\n\nSet the volume of both channels \
	to the larger of the two slider values."
bind $p.volume_label <ButtonPress-2> {
    help_item_proc $volume_label_hlpstr
}

set gain_label_hlpstr "Amplitude Gain\n\nChange the amplitude of the \
	waveforms on display."
bind $p.gain_label <ButtonPress-2> {
    help_item_proc $gain_label_hlpstr
}

# quick play
#
set qplay_hlpstr "Quick Play\n\nPlay the current utterance (0), or any \
	of the two previous (-1, -2) or two next (+1, +2) utterances \
	adjacent to the current utterance.\n\nSee help on \"Play\" by \
	clicking the middle mouse button on the \"Play\" button for \
	details on the audio play utility."
bind $p.qplay_label <ButtonPress-2> {
    help_item_proc $qplay_hlpstr
}
bind $p.play_2b <ButtonPress-2> {
    help_item_proc $qplay_hlpstr
}
bind $p.play_1b <ButtonPress-2> {
    help_item_proc $qplay_hlpstr
}
bind $p.play_0 <ButtonPress-2> {
    help_item_proc $qplay_hlpstr
}
bind $p.play_1a <ButtonPress-2> {
    help_item_proc $qplay_hlpstr
}
bind $p.play_1b <ButtonPress-2> {
    help_item_proc $qplay_hlpstr
}

# utterance traversal and control
#
set clear_hlpstr "Clear\n\nClear the transcription of the current \
	utterance. This sets the current transcription to an empty \
	string."
bind $p.clear <ButtonPress-2> {
    help_item_proc $clear_hlpstr
}

set play_hlpstr "Play\n\nPlay the current utterance through the \
	audio device. See the \"Config\" options to set the \
	various audio-related parameters. The Transcriber currently \
	supports raw binary headerless audio data files and \
	converts them to a suitable format to play.\n\nCurrent \
	platforms and audio commands supported by the Transcriber are \
	NCD (auplay), Pentium workstations running Solaris x86 \
	(audioplay), Sun SparcStations (audioplay) and DAT links \
	(naplay)."
bind $p.play <ButtonPress-2> {
    help_item_proc $play_hlpstr
}

set lexicon_hlpstr "Lexicon\n\nLoad the lexicon used as a reference for \
	the transcription process. The lexicon provides for word \
	searches. Authorized users can also make additions to the \
	lexicon through the Transcriber."
bind $p.lexicon <ButtonPress-2> {
    help_item_proc $lexicon_hlpstr
}

set verify_hlpstr "Verify Mode\n\nPlay all utterances one after the other \
	in continuous sequence so that the user can verify the \
	transcriptions. The verify function can be interrupted and \
	resumed by clicking on the \"Verify\" button, which acts as \
	a toggle switch."
bind $p.verify <ButtonPress-2> {
    help_item_proc $verify_hlpstr
}

set prev_hlpstr "Previous Utterance\n\nSelect the previous utterance \
	and set it as current."
bind $p.prev <ButtonPress-2> {
    help_item_proc $prev_hlpstr
}

set next_hlpstr "Next Utterance\n\nSelect the next utterance \
	and set it as current."
bind $p.next <ButtonPress-2> {
    help_item_proc $next_hlpstr
}

#
# end of file
