// file: snrc_gp_0.cc
//
// a simple command line parser
//

// system include files
//
#include <string.h>

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "snr_calculator.h"

#include "snr_calculator_constants.h"

// function: get_parameters_cc
//
// arguments:
//
//  int argc: (input) argc from the main program
//  char** argv: (input) argv from the main program
//  logical_1& use_hamming: (output) whether or not to use a hamming window
//  logical_1& apply_pre_emphasis: (output) whether or not to pre-emphasize
//  double& signal_thresh: (output) the nominal signal+noise thresh
//  double& noise_thresh: (output) the nominal noise thresh
//  double& frame_dur: (output) the frame duration in milliseconds
//  double& window_dur: (output) the window duration in milliseconds
//  double& sample_freq: (output) the sample frequency
//  long& num_chans: (output) number of channels in the input file
//  logical_1& swap_byte: (output) whether or not the data is byte-swapped
//  char_1* input_file: (output) the name of the input file (memory is
//                               pre-allocated)
//  long& debug_mode: (output) the debugging mode
//
// return value: a logical_1 indicating status
//
// this function parses command line arguments
//
logical_1 get_parameter_cc(int argc, char** argv, logical_1& use_hamming_a,
			   logical_1& apply_pre_emphasis_a,
			   double& signal_thresh_a, double& noise_thresh_a,
			   double& frame_dur_a, double& window_dur_a,
			   double& sample_freq_a, long& num_chans_a,
			   logical_1& swap_byte_a,
			   char_1* input_file_a, long& debug_mode_a) {

  // loop over all of the arguments and set the appropriate variables
  //
  for (long index = 1; index < argc; index++) {

    if (strcmp((char*)SNRC_OPT_USE_HAMMING, argv[index]) == (int)0) {

      // set the flag to true
      //
      use_hamming_a = ISIP_TRUE;
    }

    else if (strcmp((char*)SNRC_OPT_PRE_EMPH, argv[index]) == (int)0) {

      // set the flag to true
      //
      apply_pre_emphasis_a = ISIP_TRUE;
    }

    else if (strcmp((char*)SNRC_OPT_SIG_THRESH, argv[index]) == (int)0) {
      
      // copy the output filename
      //
      signal_thresh_a = (double)atof(argv[++index]);
    }

    else if (strcmp((char*)SNRC_OPT_NOISE_THRESH, argv[index]) == (int)0) {
      
      // copy the output filename
      //
      noise_thresh_a = (double)atof(argv[++index]);
    }

    else if (strcmp((char*)SNRC_OPT_FRAME_DUR, argv[index]) == (int)0) {
      
      // copy the output filename
      //
      frame_dur_a = (double)atof(argv[++index]);
    }

    else if (strcmp((char*)SNRC_OPT_WINDOW_DUR, argv[index]) == (int)0) {
      
      // copy the output filename
      //
      window_dur_a = (double)atof(argv[++index]);
    }

    else if (strcmp((char*)SNRC_OPT_SF, argv[index]) == (int)0) {
      
      // copy the output filename
      //
      sample_freq_a = (double)atof(argv[++index]);
    }

    else if (strcmp((char*)SNRC_OPT_NUM_CHANS, argv[index]) == (int)0) {
      
      // copy the output filename
      //
      num_chans_a = (long)atoi(argv[++index]);
    }

    else if (strcmp((char*)SNRC_OPT_SWAP, argv[index]) == (int)0) {
      
      // copy the output filename
      //
      swap_byte_a = ISIP_TRUE;
    }

    else if (strcmp((char*)SNRC_OPT_FILE_IN, argv[index]) == (int)0) {

      // copy the input filename
      //
      strcpy((char*)input_file_a, argv[++index]);
    }

    else if (strcmp((char*)SNRC_OPT_DEBUG_MODE, argv[index]) == (int)0) {

      // copy the input filename
      //
      debug_mode_a = (long)atoi(argv[++index]);
    }

    // check for help: display the help screen
    //
    else if (strcmp((char*)SNRC_OPT_HELP, argv[index]) == 0) {

      // allocate memory for the command string
      //
      char_1 command_string[ISIP_MAX_STRING_LENGTH];

      // create the command line to display the help file
      //
      sprintf((char*)command_string, (char*)ISIP_HELP_FORMAT,
	      (char*)SNRC_HELP_FILE);

      // display the help file
      //
      system((char*)command_string);
      
      // exit gracefully
      //
      return ISIP_FALSE;
    }

    else {

      // return with failure
      //
      return ISIP_FALSE;
    }
  }
  
  // exit gracefully
  //
  return ISIP_TRUE;
}
