// file: snrc_comp_4.cc
//
// finds the maximum and minimum values of the data for all channels
//

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "snr_calculator.h"

#include "snr_calculator_constants.h"

// function: find_max_min_cc
//
// arguments:
//
//  double** data: (input) sampled data [num_values_a x num_channels_a]
//  double* max: (input) max values
//  double* min: (input) min values
//  long num_values: (input) number of values in the data array
//  long num_channels: (input) number of channels of data
//  
// return value: a logical_1 indicating status
//
// this finds the maximum and minimum of each data set
//
logical_1 find_max_min_cc(double** data_a, double* max_a,
			  double* min_a, long num_values_a,
			  long num_channels_a) {

  // make sure that the data is allocated
  //
  if (data_a == (double**)NULL) {

    // return with error
    //
    return ISIP_FALSE;
  }
  
  // loop over all channels
  //
  for (long chan = 0; chan < num_channels_a; chan++) {

    // set up temporary maiximum and minimum values
    //
    double maximum = data_a[0][chan];
    double minimum = data_a[0][chan];
    
    // loop over all data
    //
    for (long samp_num = (long)1; samp_num < num_values_a; samp_num++) {

      // see if the data is greater than the maximum
      //
      if (data_a[samp_num][chan] > maximum) {

	// assign the new maximum value
	//
	maximum = data_a[samp_num][chan];
      }
      if (data_a[samp_num][chan] < minimum) {

	// assign the new minimum value
	//
	minimum = data_a[samp_num][chan];
      }            
    }

    // store the maximum and minimum values
    //
    max_a[chan] = maximum;
    min_a[chan] = minimum;    
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}

