// file: snrc_comp_3.cc
//
// finds the pdf of the data
//

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "snr_calculator.h"

#include "snr_calculator_constants.h"

// function: compute_pdf_cc
//
// arguments:
//
//  double** data: (input) sampled data [num_values_a x num_channels_a]
//  long** pdf: (output) the pdf for each channel of data
//  double** mean_vals: (output) mean values of each bin in the pdf
//  double* max: (input) max values
//  double* min: (input) min values
//  long num_values: (input) number of values in the data array
//  long num_chans: (input) number of samples in the data stream
//  
// return value: a logical_1 indicating status
//
// this finds the probability distribution function of the data
// note: the mean_vals are assumed to be initialized to zero
//
logical_1 compute_pdf_cc(double** data_a, long** pdf_a,
			 double** mean_vals_a, double* max_a,
			 double* min_a, long num_values_a,
			 long num_channels_a) {

  // make sure that the pdf and mean values are allocated
  //
  if ((pdf_a == (long**)NULL) || (mean_vals_a == (double**)NULL)) {

    // return with error
    //
    return ISIP_FALSE;
  }

  // initialize all of the pdf bins
  //
  for (long chan = 0; chan < num_channels_a; chan++) {

    for (long bin = 0; bin < SNRC_NUM_BINS; bin++) {
      pdf_a[bin][chan] = (long)0;
    }
  }

  // loop over all channels
  //
  for (long chan = 0; chan < num_channels_a; chan++) {

    // determine the spacing for each bin of the pdf
    //
    double pdf_bin_width = (max_a[chan] - min_a[chan]) /
      (double)SNRC_NUM_BINS;
    
    // loop over all data
    //
    for (long samp_num = (long)0; samp_num < num_values_a; samp_num++) {

      // see if it is equivalent to the maximum value. if so, it goes in the
      // last bin
      //
      if (data_a[samp_num][chan] == max_a[chan]) {

	(pdf_a[SNRC_NUM_BINS - 1][chan])++;
	mean_vals_a[SNRC_NUM_BINS -1][chan] += data_a[samp_num][chan];
      }
      else {

	long bin_num = (long)((data_a[samp_num][chan] - min_a[chan]) /
				pdf_bin_width);
	(pdf_a[bin_num][chan])++;
	mean_vals_a[bin_num][chan] += data_a[samp_num][chan];
      }
    }
  }

  // now loop over all channels and bins and find the mean value
  //
  for (long chan = 0; chan < num_channels_a; chan++) {
    for (long bin_num = 0; bin_num < SNRC_NUM_BINS; bin_num++) {

      if (pdf_a[bin_num][chan] == (double)0.0) {
	mean_vals_a[bin_num][chan] =  (((max_a[chan] - min_a[chan]) /
	  (double)SNRC_NUM_BINS) * ((double)2 * (double)bin_num +
				     (double)1) / (double)2) +
	  min_a[chan];
      }
      else {
	mean_vals_a[bin_num][chan] /= pdf_a[bin_num][chan];
      }
    }
  }
  // exit gracefully
  //
  return ISIP_TRUE;
}
