// file: snr_calculator.h
//

// Make sure this file is only included once
//
#ifndef __ISIP_SNR_CALCULATOR
#define __ISIP_SNR_CALCULATOR

// isip include files
//
#ifndef __ISIP_INTEGRAL
#include <integral.h>
#endif

// function prototypes
//
// function to get the command line parameters
//
logical_1 get_parameter_cc(int argc, char** argv, logical_1& use_hamming,
			   logical_1& apply_pre_emphasis,
			   double& signal_thresh, double& noise_thresh,
			   double& frame_dur, double& window_dur,
			   double& sample_freq, long& num_chans,
			   logical_1& swap_byte,
			   char_1* input_file, long& debug_mode);

// function to pre-emphasize the data
//
logical_1 pre_emphasize_data_cc(double* data, long num_samples,
				long num_channels);

// function to apply a hamming window to the data
//
logical_1 window_hamming_cc(double* data, long num_samples,
			    long num_channels);

// function to calculate the energy of a frame of data
//
logical_1 compute_energy_cc(double* data, long num_samples,
			    long num_channels, double* energy_values);

// function to find the maximum and minimum of a distribution
//
logical_1 find_max_min_cc(double** data, double* max, double* min,
			  long num_values, long num_channels);

// function to calculate the pdf of data
//
logical_1 compute_pdf_cc(double** data, long** pdf, double** mean_vals,
			 double* max, double* min, long num_values,
			 long num_channels);

// function to calculate the probabilistic snr of the data 
//
logical_1 compute_snr_cc(long** cdf, double signal_thresh,
			 double noise_thresh, long num_values,
			 long num_channels, double* max,
			 double* min, double** mean_vals,
			 double* snr_values);

// end of file
//
#endif


