// file: $ECE_8993/class/signal/v1.0/signal.h
//	

// make sure definitions are made only once
//
#ifndef __ISIP_SIGNAL
#define __ISIP_SIGNAL

// isip include files
//
#ifndef __ISIP_INTEGRAL
#include <integral.h>
#endif

#ifndef __ISIP_SIGNAL_CONSTANTS
#include "signal_constants.h"
#endif

// Signal : a class meant to handle the a raw signal file
//
class Signal {

  //---------------------------------------------------------------------------
  //
  // protected members
  //
  //---------------------------------------------------------------------------
protected:

  // filename information
  //
  unichar* fname_d;
  FILE* fp_d;                        // file pointer

  // information about the signal
  //
  long num_chans_d;                 // number of channels in the file
  long num_bytes_d;                 // number of bytes per sample per channel
  double sf_d;                      // sample frequency of the data
  logical swap_byte_flag_d;        // type of byte swapping
  double end_file_time_d;           // end time of the file
  long file_size_d;		     // number of samples in file

  // debug level
  //
  long debug_level_d;
  
  //---------------------------------------------------------------------------
  //
  // public methods
  //
  //---------------------------------------------------------------------------
public:

  // required methods
  //
  unichar* name_cc();
  volatile void error_handler_cc(unichar* method_name, unichar* message);
  logical debug_cc(FILE* fp, unichar* message);
  logical set_debug_cc(long level);  

  // destructor/constructor
  //
  ~Signal();
  Signal();

  // file methods
  //
  logical expand_cc(unichar* o_name, unichar* i_name);
  logical open_cc(unichar* filename, long mode);
  logical close_cc();
  
  // read methods
  //
  logical read_cc(double*& data, double start_time, double end_time,
		  long channel, long& num_samples);
  logical read_cc(double*& data, long start_samp, long end_samp,
		  long channel, long& num_samples);

  // write methods
  //
  logical write_cc(double* data, double start_time, long end_time);
  logical write_cc(double* data, long start_samp, long end_time);  

  // assignment methods
  //
  logical set_filename_cc(unichar* filename);
  logical set_num_chans_cc(long num_chans);
  logical set_num_bytes_cc(long num_bytes);
  logical set_sample_frequency_cc(double sf);
  logical set_swap_byte_flag_cc(logical swap_byte_flag);
  logical set_cc(unichar* filename, long num_chans, long num_bytes,
		   double sf, logical swap_byte_flag);
  
  // get methods
  //
  logical get_filename_cc(unichar* filename);
  long get_num_chans_cc();
  long get_num_bytes_cc();
  double get_sample_frequency_cc();
  logical get_swap_byte_flag_cc();
  logical get_cc(unichar* filename, long& num_chans, long& num_bytes,
		   double& sf, logical& swap_byte_flag);
  double get_end_file_time_cc();
  long get_file_size_cc();    
  
  //---------------------------------------------------------------------------
  //
  // private methods
  //
  //---------------------------------------------------------------------------
private:

};

// end of file
//
#endif
