// file: $ECE_8993/class/signal/v1.0/sig_set_0.cc
//
 
// isip include files
//
#include "signal.h"
 
#include <integral_constants.h>
#include "signal_constants.h"
 
// method: set_filename_cc
//
// arguments:
//  unichar* filename: (input) filename of the signal file
//
// return: none
//
// this method assigns the filename for the signal file
//
logical Signal::set_filename_cc(unichar* filename_a) {

  // delete the current filename
  //
  if (fname_d != (unichar*)NULL) {
    delete [] fname_d;
    fname_d = (unichar*)NULL;
  }

  // make sure the input filename is valid
  //
  if (filename_a == (unichar*)NULL) {
    error_handler_cc((unichar*)"set_filename_cc",
		     (unichar*)"input filename is invalid");
    return ISIP_FALSE;
  }

  // determine the size of the input filename and allocate that much memory
  //
  fname_d = new unichar[strlen((char*)filename_a) + 1];
  
  // copy the filename
  //
  strcpy((char*)fname_d, (char*)filename_a);

  // exit gracefully
  //
  return ISIP_TRUE;
}
