// file: $ECE_8993/class/signal/v1.0/sig_get_5.cc
//

// isip include files
//
#include "signal.h"

#include <integral_constants.h>
#include "signal_constants.h"

// method: get_cc
//
// arguments:
//   unichar* filename: (output) name of the signal file
//   long& num_chans: (output) number of channels in the signal file
//   long& num_bytes: (output) number of bytes per sample per channel
//                            of the signal file
//   double& sf: (output) sample frequency of the signal
//   logical& swap_byte_flag: (output) whether or not to swap flags
//
// return: logical indicating status
//
logical Signal::get_cc(unichar* filename_a, long& num_chans_a,
			 long& num_bytes_a, double& sf_a,
			 logical& swap_byte_flag_a) {

  // define a flag to indicate the status of the assignments
  //
  logical status_flag = ISIP_TRUE;
  
  // get the filename
  //
  if (get_filename_cc(filename_a) == ISIP_FALSE) {

    // set the flag to false
    //
    status_flag = ISIP_FALSE;
  }

  // get the number of channels
  //
  num_chans_a = get_num_chans_cc();

  // get the number of bytes per sample per channel
  //
  num_bytes_a = get_num_bytes_cc();

  // get the sample frequency
  //
  sf_a = get_sample_frequency_cc();

  // get the byte swapping mode
  //
  swap_byte_flag_a = get_swap_byte_flag_cc();
  
  // exit gracefully
  //
  return status_flag;
}





