// file: $ECE_8993/class/signal/v1.0/sig_get_0.cc
//

// isip include files
//
#include "signal.h"

#include <integral_constants.h>
#include "signal_constants.h"

// method: get_filename_cc
//
// arguments:
//   unichar*& filename: (output) filename to set (memory should be defined
//                      externally)
//
// return: a logical indicating status
//
logical Signal::get_filename_cc(unichar* filename_a) {

  // make sure that memory is allocated for the class data and for the output
  // filename
  //
  if ((fname_d == (unichar*)NULL) || (filename_a == (unichar*)NULL)) {

    // call the error handler
    //
    error_handler_cc((unichar*)"get_filename_cc",
		     (unichar*)"memory not allocated for filenames");
  }

  // copy the filenames
  //
  strcpy((char*)filename_a, (char*)fname_d);

  // exit gracefully
  //
  return ISIP_TRUE;
}




