// file: $ECE_8993/class/signal/v1.0/sig_dbg_0.cc
//

// isip include files
//
#include "signal.h"

#include <integral_constants.h>
#include "signal_constants.h"

// method: debug_cc
//
// arguments:
//  FILE* fp: (input) an open file pointer
//  unichar* message: (input) a message to be displayed
//
// return: a unichar* containing the class name
//
logical Signal::debug_cc(FILE *fp_a, unichar* message_a){
  
  // dump the internal data
  //
  if (fname_d != (unichar*)NULL) {
    fprintf(fp_a, "<%s::%s> fname_d = %s\n",
	    SIGNAL_CLASS_NAME, (char*)message_a, (char*)fname_d);
  }
  else {
    fprintf(fp_a, "<%s::%s> fname_d = NULL\n",
	    SIGNAL_CLASS_NAME, (char*)message_a);
  }
  
  fprintf(fp_a, "<%s::%s> fp_d = %lu\n",
	  SIGNAL_CLASS_NAME, (char*)message_a, (ulong)fp_d);

  fprintf(fp_a, "<%s::%s> num_chans_d = %ld\n",
	  SIGNAL_CLASS_NAME, (char*)message_a, num_chans_d);
  fprintf(fp_a, "<%s::%s> num_bytes_d = %ld\n",
	  SIGNAL_CLASS_NAME, (char*)message_a, num_bytes_d);
  fprintf(fp_a, "<%s::%s> sf_d = %f\n",
	  SIGNAL_CLASS_NAME, (char*)message_a, sf_d);
  fprintf(fp_a, "<%s::%s> swap_byte_flag_d = %lu\n",
	  SIGNAL_CLASS_NAME, (char*)message_a, (ulong)swap_byte_flag_d);
  fprintf(fp_a, "<%s::%s> end_file_time_d = %f\n",
	  SIGNAL_CLASS_NAME, (char*)message_a, end_file_time_d);
  fprintf(fp_a, "<%s::%s> debug_level_d = %ld\n",
	  SIGNAL_CLASS_NAME, (char*)message_a, debug_level_d);

  // exit gracefully
  //
  return ISIP_TRUE;
}

