// file: $ECE_8993/class/signal/v1.0/sig_close_0.cc
//

// isip include files
//
#include "signal.h"
#include <integral_constants.h>

// method: close_cc
//
// arguments: none
//
// return: a logical value indicating the status
//
logical Signal::close_cc() {

  // close the file
  //
  if (fp_d != (FILE*)NULL) {

    if (fclose(fp_d) != (int)0) {
      return ISIP_FALSE;
    }

    // reset the file pointer
    //
    fp_d = (FILE*)NULL;

    // clear the space allocated for the filename
    //
    if (fname_d != (unichar*)NULL) {
      delete [] fname_d;
      fname_d = (unichar*)NULL;
    }
  }

  // else, an error
  //
  else {
    error_handler_cc((unichar*)"close_cc",
		     (unichar*)"no open file");
    return ISIP_FALSE;
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}
