// file: $PDSP/class/fourier_transform/v3.0/ft_sr_2.cc
//
 
// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"
 
// method: sr_init_cc
//
// arguments:
//  long order_a: (input) new order
//
// return: logical indicating status
//
// creates lookup tables for sin and cosine terms. note that lookup
// table computation  is done in this method only when the order changes.
//
logical Fourier_transform::sr_init_cc(long order_a) {
  
  // if the order is the same as the previous call, we are done
  //
  if (sr_last_order_d == order_a) {
    return ISIP_TRUE;
  }
  
  // assign the new order
  //
  N_d = order_a;
  sr_last_order_d = N_d;

  // define local variables
  //
  double  q = ISIP_TWOPI / N_d;
  double t;
  long  i;
  
  // allocate space for lookup tables
  //
  sr_wr_d = new double[N_d];
  sr_wi_d = new double[N_d];
  
  q = ISIP_TWOPI / N_d;

  // compute the lookup table entries
  //
  for (i = 0; i < N_d; ++i) {
    t = q*i;
    sr_wr_d[i] = cos(t);
    sr_wi_d[i] = sin(t);
  }

  // allocate memory for the temporary workspace used
  //
  sr_temp_d = new double[N_d];
  
  // exit gracefully
  //
  return ISIP_TRUE;     
}

