// file: $PDSP/class/fourier_transform/v3.0/ft_set_5.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: set_cc (overloaded)
//
// arguments:
//  long order_a: (input) order of the transform
//  unichar* name_a: (input) corresponds to name of the algorithm to be tested
//  long type_a: (input) type of data ( real/complex )
//
// return: a logical value indicating status
//
// this method sets the parameters which are provided by the used
// from the command line
//
logical Fourier_transform::set_cc(long order_a,
					     unichar* name_a,
					     long type_a) {
  // set the parameters
  //
  N_d = order_a;
  data_type_d = type_a;
  
  // check the algorithm
  //
  algorithm_d = set_cc(name_a);

  // exit gracefully 
  //
  if (algorithm_d < (long)0) {
    return ISIP_FALSE;
  }
  else {
    return ISIP_TRUE;
  }
}

