// file: $PDSP/class/fourier_transform/v3.0/ft_set_3.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: set_cc (overloaded)
//
// arguments:
//  unichar* alg_name_a: (input) algorithm name
//
// return: an long value containing the integer code for the algorithm
//
long Fourier_transform::set_cc(unichar* alg_name_a) {

  // do an exhaustive search
  //
  if (strcmp((char*)alg_name_a, (char*)FT_DF_NAME) == (int)0) {
    return FT_DF;
  }
  else if (strcmp((char*)alg_name_a, (char*)FT_RAD2_NAME) == (int)0) {
    return FT_RAD2;
  }
  else if (strcmp((char*)alg_name_a, (char*)FT_RAD4_NAME) == (int)0) {
    return FT_RAD4;
  }
  else if (strcmp((char*)alg_name_a, (char*)FT_SR_NAME) == (int)0) {
    return FT_SR;
  }
  else if (strcmp((char*)alg_name_a, (char*)FT_FH_NAME) == (int)0) {
    return FT_FH;
  }
  else if (strcmp((char*)alg_name_a, (char*)FT_QF_NAME) == (int)0) {
    return FT_QF;
  }
  else if (strcmp((char*)alg_name_a, (char*)FT_DITF_NAME) == (int)0) {
    return FT_DITF;
  }
  else if (strcmp((char*)alg_name_a, (char*)FT_PFA_NAME) == (int)0) {
    return FT_PFA;
  }
  else {
    error_handler_cc((unichar*)"set_cc",
		     (unichar*)"unknown algorithm");
    return (long)-1;
  }
}
