// file: $PDSP/class/fourier_transform/v3.0/ft_set_2.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: set_cc (overloaded)
//
// arguments:
//  long order_a: (input) order of the transform
//  long name_a: (input) corresponds to name of the algorithm to be tested
//  long type_a: (input) type of data ( real/complex )
//
// return: a logical value indicating status
//
// this method sets the parameters which are provided by the used
// from the command line
//
logical Fourier_transform::set_cc(long order_a,
					     long name_a,
					     long type_a) {
  // set the parameters
  //
  N_d = order_a;
  data_type_d = type_a;
  
  // check the algorithm
  //
  if ((name_a == FT_DF) ||
      (name_a == FT_RAD2) || (name_a == FT_RAD4) || (name_a == FT_SR) ||
      (name_a == FT_FH) || (name_a == FT_QF) || (name_a == FT_DITF) ||
      (name_a == FT_PFA)) {

    // set the algorithm number
    //
    algorithm_d = name_a;
  }

  // else: unknown
  //
  else {
    error_handler_cc((unichar*)"set_cc",
		     (unichar*)"invalid algorithm selection");
  }

  // exit gracefully 
  //
  return ISIP_TRUE;
}



