// file: $PDSP/class/fourier_transform/v3.0/ft_rad2_2.cc
//

// isip include files
//
#include "fourier_transform.h"

#include <integral_constants.h>

// method: rad2_init_cc
//
// arguments:
//   long order_a: (input) new order
//
// return: a logical value indicating status
//
// creates lookup tables for sine and cosine terms. note that space is
// allocated in this method only when the order changes. also all temporary
// space is allocated here.
//
logical Fourier_transform::rad2_init_cc(long order_a) {

  // if the order is the same as the previous call, we are done
  //
  if (rad2_last_order_d == order_a) {
    return ISIP_TRUE;
  }

  // assign the order
  //
  N_d = order_a;
  rad2_last_order_d = N_d;

  // declare local variables
  //
  long i;
  double phi = 0;
  double wn = (double)(ISIP_TWOPI/N_d);
  
  // allocate space the lookup values
  //
  rad2_wr_d = new double[N_d];
  rad2_wi_d = new double[N_d];
  
  for (i = 0; i < N_d; ++i) {
    phi = wn*(i);
    rad2_wr_d[i]=cos(phi);
    rad2_wi_d[i]=sin(phi);
  } 
  
  // allocate memory for the temporary workspace used
  //
  rad2_temp_d = new double[N_d];
  
  // exit gracefully
  //
  return ISIP_TRUE;
}
