// file: $PDSP/class/fourier_transform/v3.0/ft_qf_3.cc
//

// system include files
//
#include <math.h>

// isip include files
//
#include "fourier_transform.h"
#include "ft_qf.h"

#include "fourier_transform_constants.h"

// method: qf_close_cc
//
// This code very closely follows the algorithm described in:
//   H.Guo et.al,"The Quick Discrete Fourier Transform",  Proceedings of
//   ICASSP 1994, pp. 453-456, SanFrancisco, CA, April 1994.
//
// This implementation is  adapted from the code written by G.A.Sitton at
// Rice University.
//
// arguments:
//   long order_a: (input) new order
//
// return: a logical value indicating status
//
// clears memory allocated as workspace for computations
//

logical Fourier_transform::qf_close_cc() {

  // Deallocate memory space
  //
  delete [] ws;
    
  // exit gracefully
  //
  return ISIP_TRUE;
}
 
