// file: $PDSP/class/fourier_transform/v3.0/ft_pow_0.cc
//
 
// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"
 
// method: is_power_cc
//
// arguments:
//  long exponent_a: (output) the required exponent
//  long base_a: (input) base provided by the user  
//  
// return: logical value indicating status
//
// this method computes exponent_a = log (base_a) of order_d;
// it returns false if order of the fourier transform requested for is
// not a power of base_a.
//
logical Fourier_transform::is_power_cc(long& exponent_a,
					 long base_a) {
  
  // define local variables
  //
  long	i = 1;
  exponent_a = 0;
  
  while (i < N_d){
    i = (long)(base_a*i);
    exponent_a = (long)(exponent_a + 1);
  }

  // if not power of two return false
  //
  if (i != N_d){
    return ISIP_FALSE;
  }
  
  // exit gracefully
  //
  return ISIP_TRUE;  
}
