// file: $PDSP/class/fourier_transform/v3.0/ft_get_0.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: get_algorithm_name_cc 
//
// arguments:
//         unichar* algorithm_name : (output) the algorithm name
//
// return: a logical value indicating status
//
// this method gets the name of the fft algorithm being used
//
logical Fourier_transform::get_algorithm_name_cc(
					unichar* algorithm_name_a) {

  // check for space
  //
  if (algorithm_name_a == (unichar*)NULL) {
    error_handler_cc((unichar*)"get_algorithm_name_cc",
		     (unichar*)"no space allocated");
  }
  
  // check the algorithm
  //
  if (algorithm_d == FT_DF) {
    strcpy((char*)algorithm_name_a,(char*)FT_DF_NAME);
  }
  
  else if (algorithm_d == FT_RAD2) {
    strcpy((char*)algorithm_name_a,(char*)FT_RAD2_NAME);
  }
  
  else if (algorithm_d == FT_RAD4) {
    strcpy((char*)algorithm_name_a,(char*)FT_RAD4_NAME);
  }
  
  else if (algorithm_d == FT_FH) {
    strcpy((char*)algorithm_name_a,(char*)FT_FH_NAME);
  }

  else if (algorithm_d == FT_SR) {
    strcpy((char*)algorithm_name_a,(char*)FT_SR_NAME);
   }

  else if (algorithm_d == FT_QF) {
    strcpy((char*)algorithm_name_a,(char*)FT_QF_NAME);
   }
  
  else if (algorithm_d == FT_DITF) {
    strcpy((char*)algorithm_name_a,(char*)FT_DITF_NAME);
  }

  else if (algorithm_d == FT_PFA) {
    strcpy((char*)algorithm_name_a,(char*)FT_PFA_NAME);
  }

  else {
    return ISIP_FALSE;
  }
  
  // exit gracefully
  //
  return ISIP_TRUE;
}

