// file: $PDSP/class/fourier_transform/v3.0/ft_fh_2.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: ft_init_cc
//
// arguments:
//   long order_a: (input) new order
//
// return: a logical value indicating status
//
// creates lookup tables for sine and cosine terms. note that space is
// allocated in this method only when the order changes. also all temporary
// space is allocated here.
//
logical Fourier_transform::fh_init_cc(long order_a) {

  // if the order is the same as the previous call, we are done
  //
  if (fh_last_order_d == order_a) {
    return ISIP_TRUE;
  }

  // assign the order
  //
  N_d = order_a;
  fh_last_order_d = N_d;

  // allocate memory for the temporary workspace used
  //
  fh_temp_d = new double[N_d];
  fh_temp_input_d = new double[N_d];
  fh_temp_output_d = new double[N_d];
  
  // exit gracefully
  //
  return ISIP_TRUE;
}
