// file: $PDSP/class/fourier_transform/v3.0/ft_err_0.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: error_handler_cc
//
// arguments:
//  unichar* mname: (input) method name in which the error occurred
//  unichar* msg: (input) message to be printed
//
// return: none
//
// this method displays an error message.
//
volatile void Fourier_transform::error_handler_cc(
						   unichar* mname_a,
						   unichar* msg_a) {
  
  // display a message
  //
  if (mname_a != (unichar*)NULL) {
    
    // check for no message
    //
    if (msg_a != (unichar*)NULL) {
      fprintf(stdout, "%s::%s: %s\n", FT_CLASS_NAME,
	      mname_a, msg_a);
    }
    else {
      fprintf(stdout, "%s::%s: fatal error\n", FT_CLASS_NAME,
	      mname_a);
    }
  }
  
  // exit very ungracefully
  //
  exit(ISIP_ERROR);
}
