// file: $PDSP/class/fourier_transform/v3.0/ft_df_2.cc
//

// isip include files
//
#include "fourier_transform.h"

#include <integral_constants.h>

// method: df_init_cc
//
// arguments:
//  long order_a: (input) new order
//
// return: a logical value indicating status
//
// creates lookup tables for sin and cosine terms. note that space is
// allocated in this method only when the order changes.
//
logical Fourier_transform::df_init_cc(long order_a) {

  // if the order is the same as the previous call, we are done
  //
  if (df_last_order_d == order_a) {
    return ISIP_TRUE;
  }

  // assign the order
  //
  N_d = order_a;
  df_last_order_d = N_d;

  // allocate space
  //
  df_wr_d = new double[N_d*N_d];
  df_wi_d = new double[N_d*N_d];
  
  // loop over all data samples
  //
  double scale_factor = ISIP_TWOPI/(double)N_d;
  long m = 0;
  long k;
  long n;

  for (k=0; k<N_d; ++k) {
    for(n=0; n<N_d; ++n) {
      
      // compute the argument
      //
      df_wi_d[m] = sin(scale_factor * (double)n * (double)k);
      df_wr_d[m] = cos(scale_factor * (double)n * (double)k);

      // increment counters
      //
      ++m;
    }
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}
