// file: $PDSP/class/fourier_transform/v3.0/ft_df_1.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: df_complex_cc
//
// arguments:
//  double* output_a: (output) output data array 
//			length of output array will always be 2*N
//			memory is allocated internally not by the calling
//			program.
//  double* input_a: (input) input data array
//			length of input array is N for real data
//			length of input array is 2*N for complex data.
//			input data memory should be allocated by the
//			calling program.
//
// return: a logical value indicating status
//
// implements a complex discrete fourier transform
//
logical Fourier_transform::df_complex_cc(double* output_a,
						    double* input_a) {
  
  // declare local variables
  //
  long k;
  long n;
  long m = 0;
  
  // check if the lookup table has been initialized
  //
  if (df_init_cc(N_d) == ISIP_FALSE) {
    error_handler_cc((unichar*)"df_complex_cc",
		     (unichar*)"error initializing df lookup table");
    return ISIP_FALSE;
  }

  // loop over all frequency samples
  //
  for (k = 0; k < N_d; ++k) {
    
    // declare local accumulators
    //
    double sumr(0.0);
    double sumi(0.0);
    
    // loop over the data
    //
    for (n = 0; n < N_d; ++n) {
      
      // compute the real part
      //
      sumr += ((df_wr_d[m] * input_a[2*n]) + (df_wi_d[m] * input_a[2*n + 1]));
      
      // compute the imaginary part
      //
      sumi += ((df_wr_d[m] * input_a[2*n + 1]) - (df_wi_d[m] * input_a[2*n]));
      
      // increment the table index
      //
      ++m;
    }
    
    // put the output data in an interlaced format
    //
    output_a[2*k] = (double)sumr;
    output_a[2*k+1] = (double)sumi;
  }
  
  // exit gracefully
  //
  return ISIP_TRUE;
}
