// file: $PDSP/class/fourier_transform/v3.0/ft_dbg_0.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: debug_cc
//
// arguments:
//  FILE* fp_a: (input) a open file pointer
//  unichar* message_a: (input) a message to be displayed
//
// return: a unichar* containing the class name
//
logical Fourier_transform::debug_cc(FILE* fp_a,
					       unichar* message_a) {
  
  // dump the internal data
  //
  fprintf(fp_a, "<%s::%s>: algorithm_d = %ld\n", FT_CLASS_NAME,
	  (char*)message_a, algorithm_d);
  fprintf(fp_a, "<%s::%s>: N_d = %ld\n", FT_CLASS_NAME,
	  (char*)message_a, N_d);

  // parameters related to the signal data type
  //
  fprintf(fp_a, "<%s::%s>: data_type_d = %ld\n", FT_CLASS_NAME,
	  (char*)message_a, data_type_d);
  
  // debugging parameters
  //
  fprintf(fp_a, "<%s::%s>: debug_level_d = %ld\n", FT_CLASS_NAME,
	  (char*)message_a, debug_level_d);
  
  // exit gracefully
  //
  return ISIP_TRUE;
}

















