// file: $PDSP/class/fourier_transform/v3.0/ft_cstr_1.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: constructor
//
// arguments: none
//
// return: none
//
// this is the default constructor
//
Fourier_transform::Fourier_transform() {

  // initialize the debugging parameter
  //
  debug_level_d = ISIP_DEBUG_NONE;

  // initialize protected data
  //
  N_d = (long)FT_DEFAULT_ORDER;
  algorithm_d = (long)FT_DEFAULT_ALGO_NAME;
  data_type_d = (long)FT_DEFAULT_DATA_TYPE;
  
  // parameters related to the discrete fourier transform algorithm
  //
  df_last_order_d = (long)-1;
  df_wr_d = (double*)NULL;
  df_wi_d = (double*)NULL;
  
  // parameters related to the radix-2 algorithm
  //
  rad2_last_order_d = (long)-1;
  rad2_wr_d = (double*)NULL;
  rad2_wi_d = (double*)NULL;
  rad2_temp_d = (double*)NULL;
  
  // parameters related to the radix-4 algorithm
  //
  rad4_last_order_d = (long)-1;
  rad4_wr_d = (double*)NULL;
  rad4_wi_d = (double*)NULL;
  rad4_temp_d = (double*)NULL;

  // parameters related to the split-radix algorithm
  //
  sr_last_order_d = (long)-1;
  sr_wr_d = (double*)NULL;
  sr_wi_d = (double*)NULL;
  sr_temp_d = (double*)NULL;

  // parameters related to the fast-hartley algorithm
  //
  fh_last_order_d = (long)-1;
  fh_temp_d = (double*)NULL;
  fh_temp_input_d = (double*)NULL;
  fh_temp_output_d = (double*)NULL;

  // parameters related to the quick fourier transform algorithm
  //
  qf_last_order_d = (long)-1;
  qf_real_coeff_d = (double*)NULL;
  qf_imag_coeff_d = (double*)NULL;
  qf_real_temp_d  = (double*)NULL;
  qf_imag_temp_d  = (double*)NULL;

  qf_comp_real_coeff_d = (double*)NULL;
  qf_comp_imag_coeff_d = (double*)NULL;
  qf_comp_real_temp_d  = (double*)NULL;
  qf_comp_imag_temp_d  = (double*)NULL;

  // parameters related to the decimation-in-time-frequency algorithm
  //
  ditf_last_order_d = (long)-1;
  ditf_wr_d = (double*)NULL;
  ditf_wi_d = (double*)NULL;
  ditf_temp_d = new double[N_d];
  ditf_trans_factor_indices_d = new long[N_d];
  ditf_indices_d = new long[N_d >> 1];
  
  // exit gracefully
  //
}


