// file: $PDSP/class/fourier_transform/v3.0/ft_comp_0.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: compute_cc
//
// arguments:
// double* output_a :(output) output data array 
//			length of output array will always be 2*N
//			memory is allocated internally not by the calling
//			program.
// double* input_a : (input) input data array
//			length of input array is N for real data
//			length of input array is 2*N for complex data.
//			input data memory should be allocated by the
//			calling program.
//
// return: a logical value indicating status
//
// this method calls the fft algorithm chosen by the user
// calls either complex or real algorithm, which ever is desired
//
logical Fourier_transform::compute_cc(double* output_a,
						 double* input_a) {

  // check the order of the algorithm and assign a default algorithm if
  // necessary
  //
  if (algorithm_check_cc() == ISIP_FALSE) {
    return ISIP_FALSE;
  }
  
  // branch on the algorithms for real data
  //
  if ((algorithm_d == FT_DF) && (data_type_d == FT_REAL)) {
    return df_real_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_RAD2) && (data_type_d == FT_REAL)) {
    return rad2_real_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_RAD4) && (data_type_d == FT_REAL)) {
    return rad4_real_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_SR) && (data_type_d == FT_REAL)) {
    return sr_real_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_FH) && (data_type_d == FT_REAL)) {
    return fh_real_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_QF) && (data_type_d == FT_REAL)) {
    return qf_real_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_DITF) && (data_type_d == FT_REAL)) {
    return ditf_real_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_PFA) && (data_type_d == FT_REAL)) {
    return ISIP_FALSE;
  }
  
  // branch on the algorithms for complex data
  //
  else if ((algorithm_d == FT_DF) && (data_type_d == FT_COMPLEX)) {
    return df_complex_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_RAD2) && (data_type_d == FT_COMPLEX)) {
    return rad2_complex_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_RAD4) && (data_type_d == FT_COMPLEX)) {
    return rad4_complex_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_SR) && (data_type_d == FT_COMPLEX)) {
    return sr_complex_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_FH) && (data_type_d == FT_COMPLEX)) {
    return fh_complex_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_QF) && (data_type_d == FT_COMPLEX)) {
    return qf_complex_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_DITF) && (data_type_d == FT_COMPLEX)) {
    return ditf_complex_cc(output_a, input_a);
  }
  else if ((algorithm_d == FT_PFA) && (data_type_d == FT_COMPLEX)) {
    return ISIP_FALSE;
  }
  
  // else: unknown algorithm
  //
  else {
    return ISIP_FALSE;
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}
