// file: $PDSP/class/fourier_transform/v3.0/ft_chk_0.cc
//

// isip include files
//
#include "fourier_transform.h"
#include "fourier_transform_constants.h"

// method: algorithm_check_cc
//
// arguments:
//  none.
//
// return: a logical value indicating status
//
logical Fourier_transform::algorithm_check_cc() {

  // define the exponent such that 2**m = N_d
  //
  long m;

  if (is_power_cc(m, (long)2) == ISIP_FALSE) {
    error_handler_cc((unichar*)"algorithm_check_cc",
		     (unichar*)"order must be a power of two");
    return ISIP_FALSE;
  }

  // else: if m is not a power of 4 and the radix 4 algorithm has
  // been requested (which requires a power of 4), generate an error
  //
  else if ((is_power_cc(m, (long)4) == ISIP_FALSE) &&
	   (algorithm_d == FT_RAD4)) {
    return ISIP_FALSE;
  }
    
  // assure that the order is greater than a threshold for certain algorithms:
  // these algorithms are optimized for orders above a certain size.
  // these include:  fht, and qft.
  //
  if ((N_d < FT_THRESH_SIZE) &&
      ((algorithm_d == FT_FH) || (algorithm_d == FT_QF))) {
    algorithm_d = FT_DEFAULT_ALGO;
  }
    
  // exit gracefully
  //
  return ISIP_TRUE;
}

