// file: $PDSP/class/fourier_transform/v3.0/fourier_transform.h
//

// this is the header for the fourier_transform class
//

// make sure definitions are only made once
//
#ifndef __ISIP_FOURIER_TRANSFORM
#define __ISIP_FOURIER_TRANSFORM

// isip include files
//
#ifndef __ISIP_INTEGRAL
#include <integral.h>
#endif

// Fourier_transform: a class that analyzes operations
//	for a variety of fourier transform algorithms
//
class Fourier_transform {
  
  //---------------------------------------------------------------------------
  //
  // protected data
  //
  //---------------------------------------------------------------------------
protected:
  
  // debugging parameters
  //
  long debug_level_d;				// amount of debugging info
  
  // parameters related to the algorithm specification
  //
  long N_d;					// order
  long algorithm_d;				// numerical identifier
  long data_type_d;				// real or complex
  
  // parameters related to the discrete fourier transform algorithm
  //
  long df_last_order_d;
  double* df_wr_d;
  double* df_wi_d;
  
  // parameters related to the radix-2 algorithm
  //
  long rad2_last_order_d;
  double* rad2_wr_d;
  double* rad2_wi_d;
  double* rad2_temp_d;    
  
  // parameters related to the radix-4 algorithm
  //
  long rad4_last_order_d;
  double* rad4_wr_d;
  double* rad4_wi_d;
  double* rad4_temp_d;
  
  // parameters related to the split-radix algorithm
  //
  long sr_last_order_d;
  double* sr_wr_d;
  double* sr_wi_d;
  double* sr_temp_d;
  
  // parameters related to the fast-hartley algorithm
  //
  long fh_last_order_d;
  double* fh_temp_d;
  double* fh_temp_input_d;
  double* fh_temp_output_d;

  // parameters related to the quick fourier transform algorithm
  //
  long qf_last_order_d;
  double* qf_real_coeff_d;
  double* qf_imag_coeff_d;
  double* qf_real_temp_d;
  double* qf_imag_temp_d;

  double* qf_comp_real_coeff_d;
  double* qf_comp_imag_coeff_d;
  double* qf_comp_real_temp_d;
  double* qf_comp_imag_temp_d;

  // workspace related pointers for quick fourier transform
  //
  double** ws; //	Workspace pointers
  double* sc;	//	Secant table addr.	
  long*   nc;	//	Current QFT length	
  long*   ic;	//	Current secant inc.	
  long*   mc;	//	Current output pruning	
  long	nn;	//	Pruned QFT input length
  long	mm;	//	Pruned QFT output length
  long	ii;	//	Current QFT recursion level
  
  // parameters related to the decimation in time frequency algorithm
  //
  long ditf_last_order_d;
  double* ditf_wr_d;
  double* ditf_wi_d;
  double* ditf_temp_d;
  long* ditf_trans_factor_indices_d;
  long* ditf_indices_d;
  
  //---------------------------------------------------------------------------
  //
  // public methods
  //
  //---------------------------------------------------------------------------
public:

  // required methods
  //
  unichar* name_cc();
  volatile void error_handler_cc(unichar* method_name, unichar* message);
  
  // destructors/constructors
  //
  ~Fourier_transform();  
  Fourier_transform();

  // set signal processing parameters
  //
  logical set_cc(long order);
  logical set_cc(long order, long algorithm);
  logical set_cc(long order, long algorithm, long data_type);

  long set_cc(unichar* algorithm);  
  logical set_cc(long order, unichar* algorithm);  
  logical set_cc(long order, unichar* algorithm, long data_type);

  // get the name of chosen algorithm
  //
  logical get_algorithm_cc(long& algorithm);
  logical get_algorithm_name_cc(unichar* algorithm_name);
  
  // computation methods
  //
  logical compute_cc(double* output, double* input);

  // debugging methods
  //
  logical set_debug_cc(long debug_level);
  logical debug_cc(FILE* fp, unichar* message);
  
  //---------------------------------------------------------------------------
  //
  // private methods
  //
  //---------------------------------------------------------------------------
private:

  // miscellaneous math methods
  //
  logical is_power_cc(long& exponent, long base);

  // method to check the order of the algorithm and assign a default
  // algorithm if the chosen algorithm does not support the provided
  // order
  //
  logical algorithm_check_cc();
  
  // algorithm methods for real signals
  //
  logical df_real_cc(double* output, double* input);
  logical rad2_real_cc(double* output, double* input);
  logical rad4_real_cc(double* output, double* input);
  logical sr_real_cc(double* output, double* input);
  logical fh_real_cc(double* output, double* input);
  logical qf_real_cc(double* output, double* input);
  logical ditf_real_cc(double* output, double* input);
  logical pfa_real_cc(double* output, double* input);

  // algorithm methods for complex signals
  //
  logical df_complex_cc(double* output, double* input);
  logical rad2_complex_cc(double* output, double* input);
  logical rad4_complex_cc(double* output, double* input);
  logical sr_complex_cc(double* output, double* input);
  logical fh_complex_cc(double* output, double* input);
  logical qf_complex_cc(double* output, double* input);
  logical ditf_complex_cc(double* output,double* input);
  logical pfa_complex_cc(double* output, double* input);
    
  //---------------------------------------------------------------------------
  //
  // auxillary methods needed for particular algorithms
  //
  //---------------------------------------------------------------------------
  // 
  // related to the discrete fourier
  //
  logical df_init_cc(long order);
  
  // related to the radix-2
  //
  logical rad2_init_cc(long order);

  // related to the radix-4
  //
  logical rad4_init_cc(long order);
  
  // related to the fast hartley
  //
  logical fh_init_cc (long order);
  logical fh_trig_next_cc (long k, double c, double s, long& p);
  
  // related to split-radix
  //
  logical sr_init_cc(long order);

  // related to quick fourier
  //
  logical qf_init_cc(long order);
  logical qf_close_cc();
  logical qf_real_dct_cc(double* coeff, double* data);
  logical qf_real_dst_cc(double* coeff, double* data);

  // related to decimation in time and frequency
  //
  logical ditf_init_cc(long order);
  
  // related to the prime factors algorithm
  //
  
};

// end of file
// 
#endif
