// file: $ISIP_SNR/util/snr_calculator/v1.0/snrc_comp_4.cc
//
// finds the maximum and minimum values of the data for all channels
//

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "snr_calculator.h"

#include "snr_calculator_constants.h"

// function: find_max_min_cc
//
// arguments:
//
//  float_4** data: (input) sampled data [num_values_a x num_channels_a]
//  float_4* max: (input) max values
//  float_4* min: (input) min values
//  int_4 num_values: (input) number of values in the data array
//  int_4 num_channels: (input) number of channels of data
//  
// return value: a logical_1 indicating status
//
// this finds the maximum and minimum of each data set
//
logical_1 find_max_min_cc(float_4** data_a, float_4* max_a,
			  float_4* min_a, int_4 num_values_a,
			  int_4 num_channels_a) {

  // make sure that the data is allocated
  //
  if (data_a == (float_4**)NULL) {

    // return with error
    //
    return ISIP_FALSE;
  }
  
  // loop over all channels
  //
  for (int_4 chan = 0; chan < num_channels_a; chan++) {

    // set up temporary maiximum and minimum values
    //
    float_4 maximum = data_a[0][chan];
    float_4 minimum = data_a[0][chan];
    
    // loop over all data
    //
    for (int_4 samp_num = (int_4)1; samp_num < num_values_a; samp_num++) {

      // see if the data is greater than the maximum
      //
      if (data_a[samp_num][chan] > maximum) {

	// assign the new maximum value
	//
	maximum = data_a[samp_num][chan];
      }
      if (data_a[samp_num][chan] < minimum) {

	// assign the new minimum value
	//
	minimum = data_a[samp_num][chan];
      }            
    }

    // store the maximum and minimum values
    //
    max_a[chan] = maximum;
    min_a[chan] = minimum;    
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}

